        FUNCTION EPOSED(X1,X2,X3,X4,M1,M2,M3,M4,E,R,NSPLIT)
C
C  COMPUTES THE EXPOSED FRACTION OF A RECTANGULAR AREA WITH
C  VERTICES AT X1,X2,X3,X4 FOR WHITE DWARF
*  Inputs:
*       X1-X4   3-VECTORS GIVING COORDINATES OF VERTICES OF A
*               SURFACE ELEMENT (IN UNITS OF RL1)
*       M1-M4   = 1 IF VERTEX IS OCCULTED
*               = 0 IF VERTEX IS VISIBLE
*       E       = UNIT VECTOR GIVING DIRECTION TOWARD EARTH
*       NSPLIT  = NUMBER OF ITERATIONS FOR EDGE REFINEMENT
*  Output:
*       EPOSED  = FRACTION OF ELEMENT THAT IS EXPOSED
        EPOSED = 0.
C
C  COUNT OCCULTED VERTICES
C
        ITEST = M1 + M2 + M3 + M4 + 1
C
C  BOX ENTIRELY EXPOSED
C
        IF(ITEST.EQ.1) THEN
          EPOSED = 1.
          RETURN
        ELSE IF(ITEST.EQ.2) THEN
C
C  ONE OCCULTED VERTEX
C
          IF(M1.GT.0) THEN
            CALL WEDGE(E,X2,X1,FR1,R,NSPLIT)
            CALL WEDGE(E,X4,X1,FR2,R,NSPLIT)
          ELSE IF(M2.GT.0) THEN
            CALL WEDGE(E,X1,X2,FR1,R,NSPLIT)
            CALL WEDGE(E,X3,X2,FR2,R,NSPLIT)
          ELSE IF(M3.GT.0) THEN
            CALL WEDGE(E,X2,X3,FR1,R,NSPLIT)
            CALL WEDGE(E,X4,X3,FR2,R,NSPLIT)
          ELSE
            CALL WEDGE(E,X1,X4,FR1,R,NSPLIT)
            CALL WEDGE(E,X3,X4,FR2,R,NSPLIT)
          END IF
          EPOSED=1.-0.5*(1.-FR1)*(1.-FR2)
          RETURN
        ELSE IF(ITEST.EQ.3) THEN
C
C  TWO OCCULTED VERTICES
C
          IT = M1*M3 + M2*M4 + 1
          IF(IT.EQ.1) THEN
C
C  REGULAR CASE, TWO ADJACENT OCCULTED VERTICES
C
            IF(M1.GT.0.AND.M2.GT.0) THEN
              CALL WEDGE(E,X3,X2,FR1,R,NSPLIT)
              CALL WEDGE(E,X4,X1,FR2,R,NSPLIT)
            ELSE IF(M2.GT.0.AND.M3.GT.0) THEN
              CALL WEDGE(E,X1,X2,FR1,R,NSPLIT)
              CALL WEDGE(E,X4,X3,FR2,R,NSPLIT)
            ELSE IF(M3.GT.0.AND.M4.GT.0) THEN
              CALL WEDGE(E,X2,X3,FR1,R,NSPLIT)
              CALL WEDGE(E,X1,X4,FR2,R,NSPLIT)
            ELSE
              CALL WEDGE(E,X2,X1,FR1,R,NSPLIT)
              CALL WEDGE(E,X3,X4,FR2,R,NSPLIT)
            END IF
            EPOSED= 0.5*(FR1+FR2)
            RETURN
          ELSE IF(IT.EQ.2) THEN
C
C  SINGULAR CASE, TWO OPPOSITE OCCULTED VERTICES
C  THIS CASE SHOULD NOT NORMALLY OCCUR.
C
            PRINT *,'*** SINGULAR POINT OCCURRED ***'
            IF(M1.GT.0.AND.M3.GT.0) THEN
              CALL WEDGE(E,X2,X1,FR1,R,NSPLIT)
              CALL WEDGE(E,X4,X1,FR2,R,NSPLIT)
              CALL WEDGE(E,X2,X3,FR3,R,NSPLIT)
              CALL WEDGE(E,X4,X3,FR4,R,NSPLIT)
            ELSE
              CALL WEDGE(E,X3,X2,FR1,R,NSPLIT)
              CALL WEDGE(E,X1,X2,FR2,R,NSPLIT)
              CALL WEDGE(E,X3,X4,FR3,R,NSPLIT)
              CALL WEDGE(E,X1,X4,FR4,R,NSPLIT)
            END IF
            EPOSED=0.25*(FR1+FR2+FR3+FR4 + (FR1-FR4)*(FR2-FR3) )
            RETURN
          END IF
        ELSE IF(ITEST.EQ.4) THEN
C
C  THREE OCCULTED VERTICES
C

          IF(M1.EQ.0) THEN
            CALL WEDGE(E,X1,X2,FR1,R,NSPLIT)
            CALL WEDGE(E,X1,X4,FR2,R,NSPLIT)
          ELSE IF(M2.EQ.0) THEN
            CALL WEDGE(E,X2,X1,FR1,R,NSPLIT)
            CALL WEDGE(E,X2,X3,FR2,R,NSPLIT)
          ELSE IF(M3.EQ.0) THEN
            CALL WEDGE(E,X3,X2,FR1,R,NSPLIT)
            CALL WEDGE(E,X3,X4,FR2,R,NSPLIT)
          ELSE
            CALL WEDGE(E,X4,X3,FR1,R,NSPLIT)
            CALL WEDGE(E,X4,X1,FR2,R,NSPLIT)
          END IF
          EPOSED=0.5*FR1*FR2
          RETURN
        ELSE IF(ITEST.EQ.5) THEN
C
C  ALL VERTICES OCCULTED
C
          EPOSED=0.
          RETURN
        END IF
        END
