        SUBROUTINE EDGE(E,X1,X2,FRACT,Q,NSPLIT)
        REAL*4 E(3),X1(3),X2(3),XON(3),XOFF(3),X(3)
        LOGICAL*1 BLINK
C
C  FINDS THE EDGE OF THE OCCULTAION ZONE AT X1 + FRACT*(X2-X1)
C  USING A BINARY SPLIT AND TEST ALGORITHM.
C  AN OCCULTATION IS ASSUMED TO OCCUR AT POSITION X2, BUT NOT AT X1.
C  THE LOGICAL FUNCTION BLINK DECIDES WHETHER AN OCCULTATION OCCURS.
C
*  INPUTS:
*       X1(3)   = 3-SPACE POSITION VECTOR (IN UNITS OF RL1)
*               OF OCCULTED ENDPOINT
*       X2(3)   = 3-SPACE POSITION VECTOR ( IN UNITS OF RL1)
*               OF VISIBLE ENDPOINT
*       E(3)    = 3-SPACE UNIT VECTOR POINTING TOWARD EARTH
*       Q       = BINARY MASS RATIO (MRED/MWD)
*       NSPLIT  = NUMBER OF REFINEMENT ITERATIONS
*  OUTPUT:
*       FRACT   = OCCULTATION BOUNDARY IS AT X1 + FRACT*(X2-X1)
C
        S = ABS(X2(1)-X1(1)) + ABS(X2(2)-X1(2)) + ABS(X2(3)-X1(3))
        IF(S.LE.0.) THEN
          FRACT = 0.5
          RETURN
        END IF
        XON(1)=X1(1)
        XON(2)=X1(2)
        XON(3)=X1(3)
        XOFF(1)=X2(1)
        XOFF(2)=X2(2)
        XOFF(3)=X2(3)
        X(1)=0.5*(XON(1)+XOFF(1))
        X(2)=0.5*(XON(2)+XOFF(2))
        X(3)=0.5*(XON(3)+XOFF(3))
        DO N=1,NSPLIT
          IF(BLINK(X,E,Q)) THEN
            XOFF(1)=X(1)
            XOFF(2)=X(2)
            XOFF(3)=X(3)
          ELSE
            XON(1)=X(1)
            XON(2)=X(2)
            XON(3)=X(3)
          END IF
          X(1)=0.5*(XON(1)+XOFF(1))
          X(2)=0.5*(XON(2)+XOFF(2))
          X(3)=0.5*(XON(3)+XOFF(3))
        END DO
C
        FRACT=(ABS(X(1)-X1(1)) + ABS(X(2)-X1(2)) + ABS(X(3)-X1(3)))/S
        RETURN
        END
