        SUBROUTINE DECLIP(RADIUS,Q,CLIN,PHASE,ACC,IFAIL)
C
C SUBROUTINE GIVING PHASE WHEN A CERTAIN RADIUS (UNITS OF L1 POINT)
C COMES COMPLETELY OUT OF ECLIPSE.
C IT WILL GO INTO ECLIPSE IN A SYMMETRICAL MANNER
C
C REAL*4 RADIUS -- RADIUS IN UNITS OF L1
C REAL*4 Q      -- MASS RATIO SECONDARY/PRIMARY
C REAL*4 CLIN   -- INCLINATION OF SYSTEM IN DEGREES
C REAL*4 ACC    -- APPROXIMATE ACCURACY OF ANSWER IN TERMS OF PHASE
C
C REAL*4 PHASE THE ANSWER
C INTEGER*4 IFAIL -- 0 IF ALL OK. 1 IF RADIUS > 1, 2 IF RADIUS IS
C                       NEVER ECLIPSED
C
        REAL*4 RADIUS,Q,CLIN,PHASE,EARTH(3),X(3)
        INTEGER*4 IFAIL
        LOGICAL BLINK,OUT,IN,SET
        DATA SET/.FALSE./
C
        PHASE = 0.
C FIND PI/2.
        IF(.NOT.SET) THEN
          CF = 2.*ATAN(1.)
          SET = .TRUE.
        END IF
        IFAIL = 1
        IF(RADIUS.GE.1.) RETURN
        IFAIL = 0
C
C GUESS A NEARBY PHASE
C
        OUT = .FALSE.
        IN = .FALSE.
        GUESS =  ASIN(RADIUS)
        PROFAC = SIND(CLIN)
        EARTH(3) = SQRT(1. - PROFAC*PROFAC)
        X(3) = 0.
C
C CALCULATE SIZE OF ANGLE STEPS REQUIRED
C THETA WILL BE INCREMENTED BY THIS MUCH
C DURING SEARCH FOR ECLIPSED PORTION OF RADIUS
C
        DEL = 4.*CF*ACC
        DTHETA = 2.*DEL*SQRT(1.-RADIUS*RADIUS)/RADIUS
        DTHETA = SQRT(DTHETA)
        DTHETA = MIN(CF/2.,DTHETA)
C
C START LOOP IN PHASE
C
        THETA = 0.
C
C CALCULATE EARTH VECTOR
C
10      EARTH(1) = COS(GUESS)*PROFAC
        EARTH(2) = -SIN(GUESS)*PROFAC
C
C CALCULATE POSITION ON DISC
C
20      XFAC = COS(THETA)
        X(1) = RADIUS*XFAC
        X(2) = RADIUS*SQRT(1. -XFAC*XFAC )
C CHECK TO SEE IF POINT IS ECLIPSED
        IF( BLINK(X,EARTH,Q) ) GOTO 30
C
C IF NOT, INCREMENT THETA, SEE IF IN RANGE AND
C CONTINUE AS BEFORE
C
        THETA = THETA + DTHETA
        IF(THETA .LT. CF) GOTO 20
C
C NO PART OF ARC ECLIPSED. LOOK AT EARLIER PHASE
C STORE OLD GUESS
C
        G1 = GUESS
C
C IF GUESS = 0. BUT STILL NO ECLIPSE
C THEN THERE IS NO ECLIPSE AT ALL
C
        IF(GUESS .LE. 0. ) THEN
          IFAIL = 2
          RETURN
        END IF
        OUT = .TRUE.
        GUESS = MAX(0.,GUESS - .1)
C
C SET START THETA BACK TO 0. OR
C THE END VALUE BEFORE AN ECLIPSED
C POINT WAS FOUND ON A SUCCESSFUL SEARCH
C
        THETA = 0.
        IF(IN) THEN
          THETA = OLD
          GUESS = ( G1 + G2 ) / 2.
          IF(ABS(GUESS-G1) .LT. DEL) GOTO 40
        END IF
        GOTO 10
C
C PART OF ARC ECLIPSED. LOOK AT LATER PHASE
C
30      G2 = GUESS
        OLD = THETA
        IN  = .TRUE.
        GUESS = MIN(GUESS + .1,CF)
        IF(OUT) THEN
           GUESS = ( G1 + G2 ) / 2.
           IF(ABS(GUESS - G1).LT. DEL) GOTO 40
        END IF
        GOTO 10
C
C FOUND PHASE TO WITHIN ACC
C
40      PHASE = GUESS/4./CF
        RETURN
        END
