        LOGICAL FUNCTION CENOBS(X, EARTH, R)
*
* Determines whether the central object is obscuring
* the point X(3). EARTH(3) is a unit vector pointing towards
* the earth vector. Assumes sphere.
* The program does not account for points being inside
* the central object.
*
* CENOBS true, then obscuration has occurred.
*
* R is the radius of the central object in the same units as X(3)
*
        REAL*4 X(3), EARTH(3), R
*
*
* Line of sight through centre of central object parameterised
* by ALPHA
*
        CENOBS = .FALSE.
        ALPHA = EARTH(1)*X(1) + EARTH(2)*X(2) + EARTH(3)*X(3)
*
* ALPHA > 0, then point is on the Earth side of central object.
*
        IF(ALPHA.GT.0.) RETURN
        DIS = X(1)*X(1) + X(2)*X(2) + X(3)*X(3) - ALPHA*ALPHA
        IF(DIS.LT.R*R) CENOBS = .TRUE.
        RETURN
        END
