C* PGWEDGE ... display calibration wedge for image display
C+
      SUBROUTINE PGWEDGE( CMIN, CMAX, IAXIS )
*
* draw vertical calibration wedge on right edge of viewport.
*
* Input:
*      CMIN      = image value corresponding to color index MINVAL (black)
*      CMAX      = image value corresponding to color index MAXVAL (white)
*      IAXIS      = 0 plain calibration wedge
*            = 1 draw box around the wedge and label the axis
*            = 2 draw box around the wedge
*            = 10 logarithmic axis (see pgenv)
C--
* Feb 1988 Keith Horne @ STScI
* Apr 1988 use PGMAP to draw the wedge.
* Nov 1988 KDH @ STScI - narrow wedge, vertical height matching viewport
* May 1990 KDH @ STScI - try to make work with X11 driver.
* Jul 1991 TRM changed from PGMAP to PGGRAY

      IMPLICIT NONE
      INTEGER NCOL
      PARAMETER (NCOL = 256)
C      REAL*4 WEDGE( NCOL )      ! use 2 X N since PGGRAY fails on 1 x N
      REAL WEDGE( NCOL*2 )      ! use 2 X N since PGGRAY fails on 1 x N
      REAL TR(6), BLACK, WHITE, PART, VLEFT, VRIGHT
      REAL V1, V2, V3, V4, CMAX, CMIN, WBOT, WRIGHT
      REAL WLEFT, WTOP, VBOT, VTOP
      INTEGER I, IODD, IEVEN, ICOLOR, IAXIS
      LOGICAL FIRSTCALL
      DATA FIRSTCALL/.TRUE./
*
* compute the wedge values
*
      IF( FIRSTCALL ) THEN
        BLACK = 0.
        WHITE = 1.
        DO I=1,NCOL
          IEVEN = I+I
          IODD = IEVEN - 1
          PART = FLOAT( I-1 ) / FLOAT( NCOL-1 )
C      WEDGE(I) = WHITE * PART + BLACK * ( 1.-PART )
          WEDGE(IODD) = WHITE * PART + BLACK * ( 1.-PART )
          WEDGE(IEVEN) = WEDGE(IODD)
        END DO
        TR(6) = 1.
        TR(5) = 0.
        TR(4) = 0.
        TR(3) = 0.
        TR(2) = 1.
        TR(1) = 0.
        FIRSTCALL = .FALSE.
      END IF
*
* save viewport and window
*
      CALL PGQVP( 0, VLEFT, VRIGHT, VBOT, VTOP )
      WRITE(*,*) 'LEFT=', VLEFT, ' RIGHT=', VRIGHT
      WRITE(*,*) ' BOT=', VBOT,  '   TOP=', VTOP
      CALL PGQWIN( WLEFT, WRIGHT, WBOT, WTOP )
      CALL PGQCI( ICOLOR )
*
* set viewport and window for a vertical wedge on right edge
*
C      CALL PGVSTAND
C      CALL PGQVP( 0, V1,V2,V3,V4 )
      V1 = .978
      V2 = .998
C      V1 = VRIGHT + 0.01* ( VRIGHT - VLEFT )
C      V1 = MIN( V1, .98 )
C      V2 = V1 + 0.02 * ( VRIGHT - VLEFT )
C      V2 = MIN( V2, 1.00 )
      V3 = VBOT
      V4 = VTOP
      CALL PGVPORT( V1, V2, V3, V4 )
C      CALL PGWINDOW( 0.5, 1.5, 0.5, FLOAT(NCOL)+0.5 )
      CALL PGWINDOW( 0.5, 2.5, 0.5, FLOAT(NCOL)+0.5 )
*
* draw the wedge
*
      CALL PGSCI(1)
      CALL PGIMAG( WEDGE, 2, NCOL, 1, 2, 1, NCOL, BLACK, WHITE, TR )
*
* draw outline around the wedge
*
      CALL PGSCI( ICOLOR )
      IF( IAXIS.EQ.1 ) THEN
        CALL PGBOX( 'BC', 0., 0, 'BC', 0.,0 )
        IF( CMIN .NE. CMAX ) THEN
          CALL PGWINDOW( 0., 1., CMIN, CMAX )
          CALL PGBOX( ' ', 0., 0, 'MST', 0., 0 )
        END IF
      ELSE IF(IAXIS.EQ.2) THEN
        CALL PGBOX( 'BC', 0., 0, 'BC', 0., 0 )
      ELSE IF( IAXIS.EQ.10 ) THEN
        CALL PGBOX( 'BC', 0., 0, 'BC', 0.,0 )
        IF( CMIN .NE. CMAX ) THEN
          CALL PGWINDOW( 0., 1., CMIN, CMAX )
          CALL PGBOX( ' ', 0., 0, 'LMST', 0., 0 )
        END IF
      END IF
*
* restore previous viewport and window
*
      CALL PGVPORT( VLEFT, VRIGHT, VBOT, VTOP )
      CALL PGWINDOW( WLEFT, WRIGHT, WBOT, WTOP )
      WRITE(*,*) 'LEFT=', VLEFT, ' RIGHT=', VRIGHT
      WRITE(*,*) ' BOT=', VBOT,  '   TOP=', VTOP
*
      RETURN
      END

