      SUBROUTINE PGSTREAM( PTYPE, VUNIT, Q, AMX, RMIN, TX, TY, ANGLE,
     &                     POINT)
*
* Plots gas stream trajectory from inner lagrangian point.
*
* Input:
*  INTEGER PTYPE   = 0 for position coordinates,
*                    1 for stream velocity
*                    2 for Keplerian velocity along stream
*                    3 for azimuthal stream velocity only
*
*  REAL    VUNIT   = velocity unit KW+KR in a velocity plot,
*                 or length of vectors in a position plot.
*  REAL    Q       = mass ratio M2/M1 = KW/KR
*  REAL    AMX    = Maximum azimuth to plot to in orbits in rotating frame.
*  REAL    RMIN    = Minimum radius to plot to
*  REAL    TX,TY   = translation vector to add to points
*  REAL    ANGLE   = rotation angle in clockwise degrees. 0 for normal plot
*  LOGICAL POINT   = TRUE to get points, FALSE to get a line.
*
* WARNING: RL1 is the unit of distance in position coordinate plots.
*
* Oct - Dec 1988 TRM @ STScI - modified from KDH routine of same name
*
* Dec 1992 TRM @OXVAD changed extensively.
*
      IMPLICIT NONE
      REAL ANGLE, VUNIT, Q, TX, TY
      REAL RXX, RXY, RYX, RYY, RMIN, TIMEMAX, AMX
      DOUBLE PRECISION R(3), V(3), DQ, STEP, DELTA, RL1, DR
      DOUBLE PRECISION EPS, ACC, TIME, RAD, ROLD, ALPHA
      REAL MU, A, LAMBDA1, M1, TWOPI, AOLD
      INTEGER PTYPE, IFAIL, NPLOT, NORB, ZONE, ZNEW
      INTEGER NBUFF
      LOGICAL POINT, DEC, DECO
      PARAMETER (NBUFF=100)
      REAL XPLOT(NBUFF), YPLOT(NBUFF), XP, YP, XPO, YPO
      DATA EPS, ACC, TIMEMAX/1.D-4, 1.D-5, 30./
*
* rotation coefficients
*
      TWOPI   = 8.*ATAN(1.)
      RXX = COS(TWOPI*ANGLE/360.)
      RXY = SIN(TWOPI*ANGLE/360.)
      RYX = -RXY
      RYY = RXX
*
* position of inner Lagrangian point
*
      DQ = Q
      CALL INLAG(DQ, RL1, IFAIL)
*
* Compute parameters A, LAMBDA1, M1 from Lubow and Shu to give
* correct initial send off (accounting also for different axes)
*
      MU = Q/(1.D0+Q)
      A  = (1.D0-MU)/RL1**3+MU/(1.-RL1)**3
      LAMBDA1 = SQRT(((A-2.D0) + SQRT(9.D0*A**2-8.D0*A))/2.D0)
      M1 = (LAMBDA1**2-2.D0*A-1)/2.D0/LAMBDA1
*
* set initial particle position, velocity and time at the L1 point
*
      R(1) = RL1-EPS
      R(2) = -M1*EPS
      R(3) = 0.D0
      V(1) = -LAMBDA1*EPS
      V(2) = -LAMBDA1*M1*EPS
      V(3) =  0.D0
      TIME = 0.D0
      CALL STFORM(RL1,0.D0,0.D0,0.D0,RL1,VUNIT,Q,PTYPE,
     &RXX,RXY,RYX,RYY,TX,TY,XP,YP)
*
* Integrate
*
      STEP = 1.D-3
      IF(POINT) THEN
        CALL PGPOINT(1,XP,YP,1)
        CALL PGPOINT(1,XP,YP,22)
        DR   = RL1/1.D2
        ZONE = 99
        ROLD = RL1
        XPO = XP
        YPO = YP
        DECO = .TRUE.
      ELSE
        NPLOT = 1
        XPLOT(NPLOT) = XP
        YPLOT(NPLOT) = YP
      END IF
      AOLD = 1.
      NORB = 0
100   CALL GSBS(R,V,DQ,STEP,ACC,DELTA)
      TIME = TIME + DELTA
*
* Step size limited to about one tenth of a radial zone at
* the most
*
      STEP = MIN(STEP, 1.D-3/MAX(1.D-3, SQRT(V(1)**2+V(2)**2)))
      STEP = MIN(STEP, 2.D-2)
      RAD  = SQRT(R(1)**2+R(2)**2)
*
* Determine azimuth and if an orbit has been completed
*
      A = ATAN2(R(2), R(1))
      IF(A.LT.0.) A = A + TWOPI
      IF(A.LT.0.25*TWOPI .AND. AOLD.GT.0.75*TWOPI) NORB = NORB + 1
      AOLD = A
*
      IF(POINT) THEN
*
* Plot points
*
        DEC  = V(1)*R(1)+V(2)*R(2) .LT. 0.D0
        ZNEW = INT(RAD/DR)
        CALL STFORM(R(1),R(2),V(1),V(2),RL1,VUNIT,Q,PTYPE,
     &  RXX,RXY,RYX,RYY,TX,TY,XP,YP)
*
* Mark turning points
*
        IF((DEC .AND. .NOT.DECO) .OR. (DECO .AND. .NOT.DEC))
     &  CALL PGPOINT(1,(XP+XPO)/2.,(YP+YPO)/2.,3)
*
* Determine whether we have crossed from one radial zone to
* another, interpolate in between if we have and plot a point.
* Larger symbol at steps of 0.1 RL1
*
        IF(ABS(ZNEW-ZONE).EQ.1) THEN
          ALPHA = (DBLE(MAX(ZNEW,ZONE))*DR-RAD)/(ROLD-RAD)
          XP = ALPHA*XPO+(1.D0-ALPHA)*XP
          YP = ALPHA*YPO+(1.D0-ALPHA)*YP
          CALL PGPOINT(1,XP,YP,1)
          IF(MOD(MAX(ZNEW,ZONE),10).EQ.0) CALL PGPOINT(1,XP,YP,22)
*
* Draw small line as velocity vector
*
          IF(PTYPE.EQ.0) THEN
            CALL PGMOVE(XP,YP)
            XPO = XP + VUNIT * ( V(1) - R(2) )
            YPO = YP + VUNIT * ( V(2) + R(1) - MU )
            CALL PGDRAW(XPO,YPO)
          END IF
        END IF
        ROLD = RAD
        XPO  = XP
        YPO  = YP
        ZONE = ZNEW
        DECO = DEC
      ELSE
*
* Plot a line
*
        CALL STFORM(R(1),R(2),V(1),V(2),RL1,VUNIT,Q,PTYPE,
     &  RXX,RXY,RYX,RYY,TX,TY,XP,YP)
        IF(NPLOT.NE.NBUFF) THEN
          NPLOT = NPLOT + 1
          XPLOT(NPLOT) = XP
          YPLOT(NPLOT) = YP
        ELSE
          CALL PGLINE(NBUFF, XPLOT, YPLOT)
          XPLOT(1) = XPLOT(NBUFF)
          YPLOT(1) = YPLOT(NBUFF)
          NPLOT = 1
        END IF
      END IF
      IF(A.LT.TWOPI*(AMX-REAL(NORB)) .AND. RAD.GT.RL1*RMIN .AND.
     &     TIME.LT.TIMEMAX) GOTO 100
*
* Flush out remaining points from buffer
*
      IF(.NOT.POINT) CALL PGLINE(NPLOT, XPLOT, YPLOT)
      RETURN
      END

      SUBROUTINE STFORM(X,Y,VX,VY,RL1,VUNIT,Q,PTYPE,
     &RXX,RXY,RYX,RYY,TX,TY,XP,YP)
*
* Apply correct transformation to get plot point
*
      IMPLICIT NONE
      REAL RXX, RXY, RYX, RYY, VKEP, MU, Q, TX, TY
      REAL XP, YP, XPO, YPO, VUNIT, VXP, VYP, VRAD
      DOUBLE PRECISION X,Y,VX,VY,RL1,RAD
      INTEGER PTYPE
*
      MU = Q/(1.+Q)
      RAD = SQRT(X*X+Y*Y)
      IF(PTYPE.EQ.0) THEN
        XPO = X / RL1
        YPO = Y / RL1
      ELSE IF(PTYPE.EQ.1) THEN
        XPO = VUNIT * ( VX - Y )
        YPO = VUNIT * ( VY + X - MU )
      ELSE IF(PTYPE.EQ.2) THEN
        VKEP = VUNIT/SQRT((1.+Q)*RAD)
        XPO = - VKEP*Y/RAD
        YPO =   VKEP*X/RAD - VUNIT*MU
      ELSE IF(PTYPE.EQ.3) THEN
        VRAD = VX*X+VY*Y
        VXP = VX - VRAD*X/RAD
        VYP = VY - VRAD*Y/RAD
        XPO = VUNIT * ( VXP - Y )
        YPO = VUNIT * ( VYP + X - MU )
      END IF
      XPO = XPO + TX
      YPO = YPO + TY
      XP  = RXX*XPO + RXY*YPO
      YP  = RYX*XPO + RYY*YPO
      RETURN
      END
