*MASKIT
* 
* MASKIT -- mask parts of data.
*
* Maskit plots a collapsed spectrum profile and then calls up the cursor
* so that you can specify regions to change error bars. It allows you to
* ignore dubious parts of the line profile (such as another line blended
* in a wing or an absorption core).
*
* FIGARO parameters:
*
* IMAGE       -- The data file
* XSTART,XEND -- X pixel limits of region to be plotted
* YSTART,YEND -- Y pixel limits of region to be plotted (2D data only)
* FACTOR      -- Factor to multiply error bars by. Huge to make data
*                negligible
* DEVICE    -- Plot device
*
*MASKIT
      SUBROUTINE MASKIT
*
* MASKIT
*
* Plots a slice of an image or a spectrum. Then calls up cursor
* to mask regions. Based on PPLOT
*
* Written by T.R. Marsh Nov/Dec 1988
*
*
*
C+
      IMPLICIT NONE
*
* Local variables
*
      INTEGER STATUS       
      INTEGER DIMS1(2)
      CHARACTER*64 DEVICE
      LOGICAL FAULT
      INTEGER NDIMS1, NELM, NX, NY, XLO, XHI
      INTEGER YLO, YHI, ADDRESS, DPTR, EPTR, XPTR, SLOT
      REAL RXLO, RXHI, RYLO, RYHI, FACTOR
      CHARACTER*64 AXIS(2)
      DOUBLE PRECISION DDUM
      INCLUDE 'DYNAMIC_MEMORY'
      INTEGER DYN_ELEMENT
*
* Initialise logical flags
*
      FAULT  = .TRUE.
*
*     Get name of data file and open it
*
      CALL DSA_OPEN(STATUS)
      CALL DSA_INPUT('IMAGE','IMAGE', STATUS)
      CALL DSA_DATA_SIZE('IMAGE',2,NDIMS1,DIMS1,NELM,STATUS)
      IF(STATUS.NE.0) GOTO 999
      IF(NDIMS1.EQ.1) THEN
        NX = DIMS1(1)
        NY = 1
      ELSE IF(NDIMS1.EQ.2) THEN
        NX = DIMS1(1)
        NY = DIMS1(2)
      END IF
*
* What region of frame
*
      IF(NDIMS1.EQ.2 .AND. NY.GT.1) THEN
        CALL PAR_RDVAL('XSTART',1.,REAL(NX),1.,' ',RXLO)
        CALL PAR_RDVAL('XEND',RXLO,REAL(NX),REAL(NX),' ',RXHI)
        XLO = NINT(RXLO)
        XHI = NINT(RXHI)
        CALL PAR_RDVAL('YSTART',1.,REAL(NY),1.,' ',RYLO)
        CALL PAR_RDVAL('YEND',RYLO,REAL(NY),REAL(NY),' ',RYHI)
        YLO = NINT(RYLO)
        YHI = NINT(RYHI)
      ELSE
        XLO = 1
        XHI = NX
        YLO = 1
        YHI = 1
      END IF
      CALL PAR_RDVAL('FACTOR',-1.E30,1.E30,100.,' ',FACTOR)
      CALL PAR_RDCHAR('DEVICE','GRAPHON',DEVICE)
*
* Map data and errors
*
      CALL DSA_MAP_DATA('IMAGE', 'READ', 'FLOAT', ADDRESS, 
     &SLOT, STATUS)
      IF(STATUS.NE.0) GOTO 999
      DPTR = DYN_ELEMENT(ADDRESS)
      CALL DSA_MAP_ERRORS('IMAGE', 'UPDATE', 'FLOAT', ADDRESS, 
     &SLOT, STATUS)
      IF(STATUS.NE.0) GOTO 999
      EPTR = DYN_ELEMENT(ADDRESS)
      CALL DSA_MAP_AXIS_DATA('IMAGE',1,'READ','FLOAT',ADDRESS,
     &SLOT,STATUS)
      IF (STATUS.NE.0) GOTO 999
      XPTR = DYN_ELEMENT(ADDRESS)
      CALL DSA_GET_AXIS_INFO('IMAGE',1,2,AXIS,1,DDUM,STATUS)
      IF(AXIS(2).EQ.' ') AXIS(2) = 'Pixels'
*
* Off we go
*
      CALL EMOD(DYNAMIC_MEM(DPTR), DYNAMIC_MEM(EPTR), NX, NY, 
     &XLO, XHI, YLO, YHI, DYNAMIC_MEM(XPTR), AXIS(2), FACTOR,
     &DEVICE)
*
      FAULT = .FALSE.
*
*     Tidy up
*
999   CONTINUE
      IF(FAULT) CALL FIG_SETERR
      CALL DSA_CLOSE(STATUS)
      RETURN
      END	


      SUBROUTINE EMOD(DATA,ERRORS,NX,NY,XLO,XHI,YLO,YHI,
     &XDATA,XLABEL,FACTOR,DEVICE)
*
* Plots average profile of region XLO to XHI, YLO to YHI of frame 
* DATA(NX,NY). Then calls up curosr to modify errors
*
      REAL DATA(NX,NY), ERRORS(NX, NY), XDATA(NX), FACTOR
      INTEGER NX, NY, XLO, XHI, YLO, YHI
      CHARACTER*(*) DEVICE
      CHARACTER*(*) XLABEL
      CHARACTER*1 CH
      INTEGER PGBEGIN, IFAIL, PGCURSE
      PARAMETER (MAXPOINT = 20000)
      REAL PLOT1(MAXPOINT), PLOT2(MAXPOINT)
      LOGICAL POS
*
      IF(XHI-XLO.GT.MAXPOINT) THEN
        CALL PAR_WRUSER('Too many points for buffer',IFAIL)
        RETURN
      END IF
      NPLOT = XHI-XLO+1
      DO I = 1, XHI-XLO+1
        PLOT1(I) = XDATA(I+XLO-1)
        PLOT2(I) = 0.
      END DO
      DO J = YLO, YHI
        DO I = XLO, XHI
          IND = I - XLO + 1
          PLOT2(IND) = PLOT2(IND) + DATA(I,J)
        END DO
      END DO
      DO I = 1, NPLOT
        PLOT2(I) = PLOT2(I)/REAL(YHI-YLO+1)
      END DO
      YMIN = PLOT2(1)
      YMAX = YMIN
      DO I = 2, NPLOT
        YMIN = MIN(PLOT2(I),YMIN)
        YMAX = MAX(PLOT2(I),YMAX)
      END DO
      DIFFY = 10**REAL(NINT(LOG10((YMAX-YMIN)/20.)))
      XMIN = PLOT1(1)
      XMAX = XMIN
      DO I = 2, NPLOT
        XMIN = MIN(PLOT1(I),XMIN)
        XMAX = MAX(PLOT1(I),XMAX)
      END DO
      DIFFX = 10**REAL(NINT(LOG10((XMAX-XMIN)/20.)))
*
* Get plot limits
*
      CALL PGLIMIT(NPLOT, PLOT1, X1, X2, DIFFX)
      CALL PGLIMIT(NPLOT, PLOT2, Y1, Y2, DIFFY)
      CALL SETLIMS(X1,X2,Y1,Y2)
*
* Select device
*
90    IFAIL = PGBEGIN(0,DEVICE,1,1)
      IF(IFAIL.NE.1) THEN
        DEVICE = '?'
        GOTO 90
      END IF
*
      CALL PGSCI(5)
      CALL PGENV(X1,X2,Y1,Y2,0,0)
      CALL PGSCI(7)
      CALL PGLABEL(XLABEL,'Mean data value',' ')
      CALL PGSCI(1)
      CALL PGBIN(NPLOT, PLOT1, PLOT2, .TRUE.)
*
      WRITE(*,*) 'Mark regions to be masked by specifying two cursor'
      WRITE(*,*) 'positions.'
100   WRITE(*,*) 'First position'
      WRITE(*,*) 'S(how), Q(uit), anything else to continue'
      IFAIL = PGCURSE(X, Y, CH)
      IF(CH.EQ.'S' .OR. CH.EQ.'s') THEN
        WRITE(*,*) 'X = ',X,', Y = ',Y
        GOTO 200
      ELSE IF(CH.EQ.'Q' .OR. CH.EQ.'q') THEN
        GOTO 300
      ELSE
        XF = X
      END IF
200   WRITE(*,*) 'Second position'
      WRITE(*,*) 'S(how), Q(uit), anything else to continue'
      IFAIL = PGCURSE(X, Y, CH)
      IF(CH.EQ.'S' .OR. CH.EQ.'s') THEN
        WRITE(*,*) 'X = ',X,', Y = ',Y
        GOTO 200
      ELSE IF(CH.EQ.'Q' .OR. CH.EQ.'q') THEN
        GOTO 300
      ELSE
        XS = X
      END IF
*
* Identify position in axis array (assume monotnic)
*
      POS = XDATA(NX).GT.XDATA(1)
      IF(POS) THEN
        N1 = 1
        N2 = NX
        NS = 1
      ELSE
        N1 = NX
        N2 = 1
        NS = -1
      END IF
      DO N = N1, N2, NS
        IF(XDATA(N).GT.XF) THEN
          I1 = N
          GOTO 210
        END IF
      END DO
      I1 = N2 + NS
210   CONTINUE
      DO N = N1, N2, NS
        IF(XDATA(N).GT.XS) THEN
          I2 = N
          GOTO 220
        END IF
      END DO
      I2 = N2 + NS
220   CONTINUE
      IF(POS .AND. I2.GT.I1) THEN
        J1 = I1
        J2 = I2 - 1
      ELSE IF(POS) THEN
        J1 = I2
        J2 = I1 - 1
      ELSE IF(I2.GT.I1) THEN
        J1 = I1 + 1
        J2 = I2
      ELSE
        J1 = I2 + 1
        J2 = I1
      END IF
      J1 = MAX(1, MIN(NX, J1))
      J2 = MAX(1, MIN(NX, J2))
      CALL PGSLS(2)
      CALL PGMOVE(XDATA(J1), Y1)
      CALL PGDRAW(XDATA(J1), Y2)
      CALL PGMOVE(XDATA(J2), Y1)
      CALL PGDRAW(XDATA(J2), Y2)
      Y = (Y1+Y2)/2.
      CALL PGDRAW(XDATA(J1), Y)
      CALL PGDRAW(XDATA(J2), Y)
      CALL PGSLS(1)
      DO I = 1, NY
        DO J = J1, J2
          ERRORS(J,I) = FACTOR*ERRORS(J,I)
        END DO
      END DO
      GOTO 100
300   CALL PGEND
      RETURN
      END

