*DOPPLER
*
* Doppler is an NDF monolith concerned with Doppler tomography.
* Transfer to NDF started on 13/03/98.
*
* Routines transferred:
*
*  comdat   -- computes data equivalent to an image. Tested: 17/03/98
*  imsymm   -- generates an axi-symmetric image.
*  makimg   -- generates initial image. Tested: 13/03/98
*  memit    -- iterates images. Tested: 18/03/98
*  optgam   -- optimises the systemic velocity.
*  optscl   -- optimises the scaling of an image. Tested: 18/03/98
*
* Routines to be transferred:
*
*  maskit   -- masks data.
*  radpot   -- generates radial profile of an image.
*
*DOPPLER
      SUBROUTINE DOPPLER(STATUS)
      INCLUDE 'SAE_PAR'
      INCLUDE 'PAR_PAR'
      INTEGER STATUS
      CHARACTER*(PAR__SZNAM) ACTION
C
      IF(STATUS.NE.SAI__OK) RETURN
C
C Get action name
C
      CALL TASK_GET_NAME(ACTION, STATUS)
C
      IF(ACTION.EQ.'COMDAT') THEN
         CALL COMDAT(STATUS)
      ELSE IF(ACTION.EQ.'IMSYMM') THEN
         CALL IMSYMM(STATUS)
      ELSE IF(ACTION.EQ.'MEMIT') THEN
         CALL MEMIT(STATUS)
      ELSE IF(ACTION.EQ.'MAKIMG') THEN
         CALL MAKIMG(STATUS)
      ELSE IF(ACTION.EQ.'OPTGAM') THEN
         CALL OPTGAM(STATUS)
      ELSE IF(ACTION.EQ.'OPTSCL') THEN
         CALL OPTSCL(STATUS)
      ELSE IF(ACTION.EQ.'ECLIPSE') THEN
         CALL ECLIPSE(STATUS)
      ELSE IF(ACTION.EQ.'MAKCIRC') THEN
         CALL MAKCIRC(STATUS)
      ELSE
         CALL MSG_SETC('COMMAND', ACTION)
         STATUS = SAI__ERROR
         CALL ERR_OUT(' ',
     &        'Command ^COMMAND not recognised by doppler.f',
     &        STATUS)
      END IF
      END
