      SUBROUTINE DEFAULT
*
* D E F A U L T
*
* Written by T.R. Marsh, computes default image (for checking
* default computation and information purposes).
*
*
* FIGARO variables:
*
* IMAGE     -- The image file to load
*
* OUTPUT    -- Default image file to dump
*
* NDEF      -- Default option
*              (No #1 for consistency with MEMIT where 1 is uniform)
*              2 = Gaussian blurr
*              3 = Power law
*              4 = Gaussian blurr + radial profile
*
* BLURR     -- Amount of blurring for Gaussian default option
*
* EXPON     -- Exponent of power law
*
* XCEN      -- X coordinate of centre for power law
*
* YCEN      -- Y coordinate of centre for power law
*
* RADMIN    -- Inner radius of power law. (Constant inside)
*
* NUPDAT    -- Update interval for default.
*
*
      IMPLICIT NONE
*
* Functions
*
      INTEGER ICH_LEN, LIB$GET_VM, LIB$FREE_VM
*
* Local variables
*
      INTEGER STATUS
      INTEGER DIMS1(3), DIMS2(2)
      CHARACTER*32 IMAGE, OUTPUT, DATA
      CHARACTER*32 CMPNAM, IMCOMP, SPCOMP, TYPE*16
      LOGICAL IOPEN, OOPEN, OMAP, IMAP
      LOGICAL FAULT, WMAP
      INTEGER NDIMS1, NDIMS2, NELM, LFILE, IWPT
      INTEGER I, IFAIL, J, IEFIND, ICFIND, NBYTES
      INTEGER NDEF, NSIDE, NIMAGE, IPIN1, IPIN2
      REAL RMAX, RDEF, BLURR, VPIX
      REAL EXPON, RADMIN, XCEN, YCEN, DUMMY
*
* Initialise logical flags
*
      FAULT  = .TRUE.
      IOPEN  = .FALSE.
      IMAP   = .FALSE.
      OOPEN  = .FALSE.
      OMAP   = .FALSE.
      WMAP   = .FALSE.
*
* Get image region output file 
*
      CALL PAR_RDCHAR('IMAGE',' ',IMAGE)
      CALL DTA_ASFNAM('IMAGE',IMAGE(:ICH_LEN(IMAGE))//'.DST',
     &           'OLD',0,' ',STATUS)
      IF (STATUS.NE.0) THEN
         CALL FIG_DTAERR(STATUS,'Unable to open input file')
         GOTO 999
      END IF
      IOPEN = .TRUE.
*
*     Get size of data array
*
      CALL DTA_SZVAR('IMAGE.Z.DATA',10,NDIMS1,DIMS1,STATUS)
      IF (STATUS.NE.0) THEN
         CALL FIG_DTAERR(STATUS,'Unable to get dimensions of frame')
         GOTO 999
      END IF
      IF(NDIMS1.NE.2 .AND. NDIMS1.NE.3) THEN
        CALL PAR_WRUSER('Invalid number of dimensions',STATUS)
        GOTO 999
      END IF
      NSIDE = DIMS1(1)
      IF(DIMS1(2).NE.DIMS1(1)) THEN
        CALL PAR_WRUSER('Images not square', STATUS)
        GOTO 999
      END IF
      IF(NDIMS1.EQ.3) THEN
        NIMAGE = DIMS1(3)
      ELSE
        NIMAGE = 1
      END IF
*
* Read pixel size
*
      CALL DTA_RDVARF('IMAGE.HEAD.VPIX',1,VPIX,STATUS)
      IF(STATUS.NE.0) THEN
        CALL PAR_WRUSER('Unable to read pixel size', STATUS)
        CALL PAR_WRUSER('Will set equal to 1', STATUS)
        VPIX = 1.
      END IF
*
* Get output file
*
      CALL PAR_RDCHAR('OUTPUT',' ',OUTPUT)
*
* Get parameters
*
      CALL PAR_RDVAL('NDEF',2.,4.,1.,' ',RDEF)
      NDEF = NINT(RDEF)
      IF(NDEF.EQ.2) THEN
        CALL PAR_RDVAL('BLURR',0.,1.E10,10.,' ',BLURR)
      ELSE IF(NDEF.EQ.3) THEN
        CALL PAR_RDVAL('EXPON',-100., 100., 0., ' ', EXPON)
        CALL PAR_RDVAL('XCEN',-1.E10,1.E10, 0., ' ', XCEN)
        CALL PAR_RDVAL('YCEN',-1.E10,1.E10, 0., ' ', YCEN)
        XCEN = XCEN/VPIX + REAL(1+NSIDE)/2.
        YCEN = YCEN/VPIX + REAL(1+NSIDE)/2.
        CALL PAR_RDVAL('RADMIN',0.,1.E10, 0., ' ', RADMIN)
      ELSE IF(NDEF.EQ.4) THEN
        CALL PAR_RDVAL('BLURR',0.,1.E10,10.,' ',BLURR)
        CALL PAR_RDVAL('XCEN',-1.E10,1.E10, 0., ' ', XCEN)
        CALL PAR_RDVAL('YCEN',-1.E10,1.E10, 0., ' ', YCEN)
        XCEN = XCEN/VPIX + REAL(1+NSIDE)/2.
        YCEN = YCEN/VPIX + REAL(1+NSIDE)/2.
      END IF
*
* Get workspace
*
      IF(NDEF.EQ.3 .OR. NDEF.EQ.4) THEN
        NBYTES = 4*NSIDE*NSIDE
        STATUS = LIB$GET_VM(NBYTES, IWPT)
        IF(.NOT.STATUS) THEN
          CALL PAR_WRUSER('Could not get workspace', STATUS)
          GOTO 999
        END IF
        WMAP = .TRUE.
      END IF
*
* Open output file
* Copy input to output
*
      CALL DTA_ASFNAM('OUTPUT',OUTPUT(:ICH_LEN(OUTPUT))//'.DST',
     &           'NEW',12,'Doppler',STATUS)
      IF (STATUS.NE.0) THEN
         CALL FIG_DTAERR(STATUS,'Unable to open output file')
         GOTO 999
      END IF
      OOPEN = .TRUE.
      CALL DTA_CYVAR('IMAGE','OUTPUT',STATUS)
      IF(STATUS.NE.0) THEN
        CALL PAR_WRUSER('Could not copy input to output', STATUS)
        GOTO 999
      END IF
*
* Map input and output images
*
      NELM = NSIDE*NSIDE*NIMAGE
      CALL DTA_MRVARF('IMAGE.Z.DATA',NELM,IPIN1,STATUS)
      IF(STATUS.NE.0) THEN
        CALL PAR_WRUSER('Unable to map image file', STATUS)
        GOTO 999
      END IF
      IMAP = .TRUE.
      CALL DTA_MUVARF('OUTPUT.Z.DATA',NELM,IPIN2,STATUS)
      IF(STATUS.NE.0) THEN
        CALL PAR_WRUSER('Unable to map output file', STATUS)
        GOTO 999
      END IF
      OMAP = .TRUE.
*
* Compute default
*
      IF(WMAP) THEN
        CALL FIGDEF(NDEF, %VAL(CNF_PVAL(IPIN1)), %VAL(CNF_PVAL(IPIN2)), 
     :              %VAL(CNF_PVAL(IWPT)),
     &  BLURR, EXPON, XCEN, YCEN, RADMIN, NSIDE, NSIDE, NIMAGE)
      ELSE 
        CALL FIGDEF(NDEF, %VAL(CNF_PVAL(IPIN1)), %VAL(CNF_PVAL(IPIN2)), 
     :              DUMMY,
     &  BLURR, EXPON, XCEN, YCEN, RADMIN, NSIDE, NSIDE, NIMAGE)
      END IF
      FAULT = .FALSE.
*
*     Tidy up
*
999   CONTINUE
      IF(FAULT) CALL FIG_SETERR
      IF (IMAP) THEN
         CALL DTA_FRVAR('IMAGE.Z.DATA',STATUS)
         IF (STATUS.NE.0) THEN
           CALL FIG_DTAERR(STATUS,'Error unmapping input data')
         END IF
      END IF
      IF (IOPEN) THEN
         CALL DTA_FCLOSE('IMAGE',STATUS)
         IF (STATUS.NE.0) THEN
           CALL FIG_DTAERR(STATUS,'Error closing input file')
         END IF
      END IF
      IF (OMAP) THEN
         CALL DTA_FRVAR('OUTPUT.Z.DATA',STATUS)
         IF (STATUS.NE.0) THEN
           CALL FIG_DTAERR(STATUS,'Error unmapping output data')
         END IF
      END IF
      IF (OOPEN) THEN
         CALL DTA_FCLOSE('OUTPUT',STATUS)
         IF (STATUS.NE.0) THEN
           CALL FIG_DTAERR(STATUS,'Error closing output file')
         END IF
      END IF
      IF(WMAP) THEN
        STATUS = LIB$FREE_VM(NBYTES,IWPT)
        IF(.NOT.STATUS) THEN
          CALL PAR_WRUSER('Error freeing virtual memory', STATUS)
        END IF
      END IF
      RETURN
      END	
