      SUBROUTINE ADDNOS
*
* Adds noise and creates or overwrites error bars array
* for an arbitrary image. Noise is gaussian and defined by 
* A*SQRT(C+S) where A and C are constants and S is the signal.
*
* FIGARO variables:
*
* IMAGE     -- The image file to load
*
* OUTPUT    -- Output file with added noise.
*
*
      IMPLICIT NONE
      INCLUDE 'DTASRC:DTACODES.INC'
      INCLUDE 'CNF_PAR'
*
* Functions
*
      INTEGER ICH_LEN
*
* Local variables
*
      INTEGER STATUS
      INTEGER DIMS1(10), DIMS2(10)
      CHARACTER*32 IMAGE, OUTPUT
      CHARACTER*32 CMPNAM, IMCOMP, SPCOMP, TYPE*16
      LOGICAL IOPEN, OOPEN, OMAP1, OMAP2, FAULT
      INTEGER NDIMS1, NDIMS2, NELM, LFILE, IPOS
      INTEGER I, IFAIL, J, IEFIND, ICFIND, NMSTAT
      INTEGER ISEED, NBLOCK, NSTAT
      REAL SNCONT, CONT, SEED
      CHARACTER*80 STRING
      INTEGER IPIN1, IPIN2
*
* Initialise logical flags
*
      FAULT = .TRUE.
      IOPEN  = .FALSE.
      OOPEN  = .FALSE.
      OMAP1  = .FALSE.
      OMAP2  = .FALSE.
*
* Get image file 
*
      CALL PAR_RDCHAR('IMAGE',' ',IMAGE)
      CALL DTA_ASFNAM('IMAGE',IMAGE(:ICH_LEN(IMAGE))//'.DST',
     &           'OLD',0,' ',STATUS)
      IF (STATUS.NE.0) THEN
         CALL FIG_DTAERR(STATUS,'Unable to open input file')
         GOTO 999
      END IF
      IOPEN = .TRUE.
*
*     Get size of data array
*
      CALL DTA_SZVAR('IMAGE.Z.DATA',10,NDIMS1,DIMS1,STATUS)
      IF (STATUS.NE.0) THEN
        CALL FIG_DTAERR(STATUS,'Unable to get dimensions of frame')
        GOTO 999
      END IF
      NELM = 1
      DO I = 1, NDIMS1
        NELM = NELM*DIMS1(I)
      END DO
*
* Get name of file for output data
*
      NBLOCK = MAX(3, NELM/64)
      CALL PAR_RDCHAR('OUTPUT',' ',OUTPUT)
      CALL DTA_ASFNAM('OUTPUT',OUTPUT(:ICH_LEN(OUTPUT))//'.DST',
     &           'NEW',NBLOCK,' ',STATUS)
      IF (STATUS.NE.0) THEN
         CALL FIG_DTAERR(STATUS,'Unable to open output file')
         GOTO 999
      END IF
      OOPEN = .TRUE.
*
* Copy input to output 
*
      CALL DTA_CYVAR('IMAGE','OUTPUT',STATUS)
      IF(STATUS.NE.0) THEN
        CALL PAR_WRUSER('Error copying input to output', NSTAT)
        GOTO 999
      END IF
*
* Get parameters to specify amount of noise to add
*
      CALL PAR_RDVAL('SNCONT', 1.E-10, 1.E30, 5., ' ', SNCONT)
      CALL PAR_RDVAL('CONT', 1.E-20, 1.E30, 1., ' ', CONT)
      CALL PAR_RDVAL('ISEED', 1., 4.E9, 12345., ' ', SEED)
      ISEED = 2*(NINT(SEED)/2)+1
*
* Map output
*
      CALL DTA_MUVARF('OUTPUT.Z.DATA',NELM,IPIN1,STATUS)
      IF(STATUS.NE.0) THEN
        CALL PAR_WRUSER('Unable to map data', STATUS)
        GOTO 999
      END IF
      OMAP1 = .TRUE.
*
* Create .Z.ERRORS component if not already present.
* Map
*
      CALL DTA_CRNAM('OUTPUT.Z','ERRORS',NDIMS1,DIMS1,SPCOMP,STATUS)
      CALL DTA_CRVAR(SPCOMP,'FLOAT',STATUS)
      IF(STATUS.NE.DTA_EXIST .AND. STATUS.NE.0) THEN
        CALL PAR_WRUSER('Error creating '//SPCOMP,STATUS)
        GOTO 999
      END IF
      CALL DTA_MUVARF('OUTPUT.Z.ERRORS',NELM,IPIN2,STATUS)
      IF(STATUS.NE.0) THEN
        CALL PAR_WRUSER('Unable to map data', STATUS)
        GOTO 999
      END IF
      OMAP2 = .TRUE.
*
* Compute data
*
      CALL ADD_NOS(%VAL(CNF_PVAL(IPIN1)), %VAL(CNF_PVAL(IPIN2)), 
     :             NELM, SNCONT,
     &CONT, ISEED)
*
*     Tidy up
*
999   CONTINUE
      IF(FAULT) CALL FIG_SETERR
      IF (OMAP1) THEN
         CALL DTA_FRVAR('OUTPUT.Z.DATA',STATUS)
         IF (STATUS.NE.0) THEN
           CALL FIG_DTAERR(STATUS,'Error unmapping output')
         END IF
      END IF
      IF (OMAP2) THEN
         CALL DTA_FRVAR('OUTPUT.Z.ERRORS',STATUS)
         IF (STATUS.NE.0) THEN
           CALL FIG_DTAERR(STATUS,'Error unmapping output errors')
         END IF
      END IF
      IF (OOPEN) THEN
        CALL DTA_FCLOSE('OUTPUT',STATUS)
        IF (STATUS.NE.0) THEN
          CALL FIG_DTAERR(STATUS,'Error closing output file')
        END IF
      END IF
      IF (IOPEN) THEN
         CALL DTA_FCLOSE('IMAGE',STATUS)
         IF (STATUS.NE.0) THEN
           CALL FIG_DTAERR(STATUS,'Error closing input  file')
         END IF
      END IF
      RETURN
      END	

      SUBROUTINE ADD_NOS(DATA, ERRORS, NPOINT, SNCONT, CONT, ISEED)
*
* Adds gaussian noise to DATA(NPOINT), puts sigma of amount added
* into ERRORS(NPOINT).
* Noise specified by SNCONT and CONT. CONT is an effective
* constant that is added to the data (e.g. a continuum) while
* SNCONT is the signal-to-noise ratio if no signal was present.
* Noise = (SQRT(CONT)/SNCONT)*SQRT(CONT+DATA(I))
* ISEED is a positive large, odd integer to start off random number
* generator. Note that the constant is only used to compute the noise
* and not actually added
*
      REAL DATA(NPOINT), ERRORS(NPOINT), SNCONT, CONT
      INTEGER ISEED
*
      ISEED = - ISEED
      FACTOR = SQRT(CONT)/SNCONT
      DO I = 1, NPOINT
        SIGMA = FACTOR*SQRT(CONT+DATA(I))
        ERRORS(I) = SIGMA
        DATA(I) = GAUSS2(DATA(I), SIGMA, ISEED)
      END DO
      RETURN
      END
