#!/star/bin/ndfperl
#
# Plots a Doppler map
#
# T.R.Marsh 27/8/98

use PDL;
use PDL::IO::NDF;
use PDL::Graphics::PGPLOT;
use PGPLOT;

if(@ARGV < 1){
    print "Name of map: ";
    chop ($map = <STDIN>);
}else{
    $map = $ARGV[0];
}
-e "$map.sdf" or die "$map.sdf does not exist\n";

if(@ARGV < 2){
    $display = '/xs';
}else{
    $display = $ARGV[1];
}


$image = rndf("$map.sdf");
$hdr   = $image->gethdr;
$vpix  = $$hdr{NDF_EXT}{DOPPLER_MAP}{VPIX};
@dims  = $image->dims;
(@dims > 1 && @dims < 4) or die "Image has wrong number of dimensions\n";
$wave = $$hdr{NDF_EXT}{DOPPLER_MAP}{WAVE};
$wave =~ s/\[//;
$wave =~ s/\]//;
@wave = split(' ',$wave);

$nx = $dims[0];
$ny = $dims[1];
if(@dims == 2){
    $nz = 1;
}else{
    $nz = $dims[2];
}

$tr[5] = $tr[1] = $vpix; 
$tr[0] = -$tr[1]*($nx-1)/2.;
$tr[3] = -$tr[5]*($ny-1)/2.;
$tr[2] = $tr[4] = 0.;

$ptr = pdl [@tr];

$x1 = $tr[0] + $tr[1]*(-0.5);
$x2 = $tr[0] + $tr[1]*($nx-0.5);
$y1 = $tr[3] + $tr[5]*(-0.5);
$y2 = $tr[3] + $tr[5]*($ny-0.5);

pgopen($device);
hold;
pgsch(1.2);
pgscf(2);

for($i=0;$i<$nz;$i++){
    pgpage();
    $want = $image->slice(":,:,($i)");
    $min  = $want->min;
    $max  = $want->max;
    pgvstd();
    pgwnad($x1,$x2,$y1,$y2);
    imag($want,$min,$max,$ptr);
    pgbox('BCNST',0.,0,'BCNST',0.,0);
    pglab('V\dX\u (km/s)','V\dY\u (km/s)',"Wavelength = $wave[$i]");
}
pgclos();
