      SUBROUTINE REALFT(FDATA,N,ISIGN)
*
* Numerical recipes routine to compute FFT of
* a real array of data. Replaces FDATA by the
* positive frequency half of the complex
* transform. Real valued first and last
* components are stored in FDATA(1) and FDATA(2)
* N must be a power of 2. ISIGN = 1, this routine
* computes inverse of transform of a real array
* (which must be multiplied by 1/N. to get back to beginning)
*
      REAL*8 WR,WI,WPR,WPI,WTEMP,THETA
      REAL FDATA(N)
*
      THETA=6.28318530717959D0/2.0D0/DFLOAT(N/2)
      C1=0.5
      IF (ISIGN.EQ.1) THEN
        C2=-0.5
        CALL FOUR1(FDATA,N/2,+1)
      ELSE
        C2=0.5
        THETA=-THETA
      ENDIF
      WPR=-2.0D0*DSIN(0.5D0*THETA)**2
      WPI=DSIN(THETA)
      WR=1.0D0+WPR
      WI=WPI
      N2P3=N+3
      DO I=2,N/4
        I1=2*I-1
        I2=I1+1
        I3=N2P3-I2
        I4=I3+1
        WRS=SNGL(WR)
        WIS=SNGL(WI)
        H1R=C1*(FDATA(I1)+FDATA(I3))
        H1I=C1*(FDATA(I2)-FDATA(I4))
        H2R=-C2*(FDATA(I2)+FDATA(I4))
        H2I=C2*(FDATA(I1)-FDATA(I3))
        FDATA(I1)=H1R+WRS*H2R-WIS*H2I
        FDATA(I2)=H1I+WRS*H2I+WIS*H2R
        FDATA(I3)=H1R-WRS*H2R+WIS*H2I
        FDATA(I4)=-H1I+WRS*H2I+WIS*H2R
        WTEMP=WR
        WR=WR*WPR-WI*WPI+WR
        WI=WI*WPR+WTEMP*WPI+WI
      ENDDO
      IF (ISIGN.EQ.1) THEN
        H1R=FDATA(1)
        FDATA(1)=H1R+FDATA(2)
        FDATA(2)=H1R-FDATA(2)
      ELSE
        H1R=FDATA(1)
        FDATA(1)=C1*(H1R+FDATA(2))
        FDATA(2)=C1*(H1R-FDATA(2))
        CALL FOUR1(FDATA,N/2,-1)
      ENDIF
      RETURN
      END

      SUBROUTINE FOUR1(FDATA,NN,ISIGN)
*
* Numerical recipes FFT routine
*
* Replaces FDATA by its DFT, if ISIGN=1, or by
* NN times inverse DFT if ISIGN=-1. FDATA real
* array of 2*NN. NN must be a power of 2
*
      REAL*8 WR,WI,WPR,WPI,WTEMP,THETA
      REAL FDATA(2*NN)
*
      N=2*NN
      J=1
      DO I=1,N,2
        IF(J.GT.I)THEN
          TEMPR=FDATA(J)
          TEMPI=FDATA(J+1)
          FDATA(J)=FDATA(I)
          FDATA(J+1)=FDATA(I+1)
          FDATA(I)=TEMPR
          FDATA(I+1)=TEMPI
        ENDIF
        M=N/2
1       IF ((M.GE.2).AND.(J.GT.M)) THEN
          J=J-M
          M=M/2
          GO TO 1
        ENDIF
        J=J+M
      ENDDO
      MMAX=2
2     IF (N.GT.MMAX) THEN
        ISTEP=2*MMAX
        THETA=6.28318530717959D0/(ISIGN*MMAX)
        WPR=-2.D0*DSIN(0.5D0*THETA)**2
        WPI=DSIN(THETA)
        WR=1.D0
        WI=0.D0
        DO M=1,MMAX,2
          DO I=M,N,ISTEP
            J=I+MMAX
            TEMPR=SNGL(WR)*FDATA(J)-SNGL(WI)*FDATA(J+1)
            TEMPI=SNGL(WR)*FDATA(J+1)+SNGL(WI)*FDATA(J)
            FDATA(J)=FDATA(I)-TEMPR
            FDATA(J+1)=FDATA(I+1)-TEMPI
            FDATA(I)=FDATA(I)+TEMPR
            FDATA(I+1)=FDATA(I+1)+TEMPI
          ENDDO
          WTEMP=WR
          WR=WR*WPR-WI*WPI+WR
          WI=WI*WPR+WTEMP*WPI+WI
        ENDDO
        MMAX=ISTEP
        GO TO 2
      ENDIF
      RETURN
      END
