      SUBROUTINE POLINT(XA,YA,N,X,Y,DY,IFAIL)
*
* Numerical Recipes routine needed by QROMB
*
      INTEGER N,NMAX
      DOUBLE PRECISION DY,X,Y,XA(N),YA(N)
      PARAMETER (NMAX=10)
      INTEGER I,M,NS
      DOUBLE PRECISION DEN,DIF,DIFT,HO,HP,W,C(NMAX),D(NMAX)
*
      IFAIL = 0
      NS=1
      DIF=ABS(X-XA(1))
      DO I=1,N
        DIFT=ABS(X-XA(I))
        IF (DIFT.LT.DIF) THEN
          NS=I
          DIF=DIFT
        END IF
        C(I)=YA(I)
        D(I)=YA(I)
      END DO
      Y=YA(NS)
      NS=NS-1
      DO M=1,N-1
        DO I=1,N-M
          HO=XA(I)-X
          HP=XA(I+M)-X
          W=C(I+1)-D(I)
          DEN=HO-HP
          IF(DEN.EQ.0.D0) THEN
            IFAIL = 1
            GOTO 999
          END IF
          DEN=W/DEN
          D(I)=HP*DEN
          C(I)=HO*DEN
        END DO
        IF (2*NS.LT.N-M)THEN
          DY=C(NS+1)
        ELSE
          DY=D(NS)
          NS=NS-1
        END IF
        Y=Y+DY
      END DO
999   RETURN
      END
