      SUBROUTINE SPLSET(Y,N,U,Y2)
*
* Numerical recipes spline routine specialised to uniform X
* and zero first derivatives at ends. Run this first to generate
* Y2 and then run SPLINT to interpolate
*
      IMPLICIT NONE
      INTEGER N, I, K
      REAL Y(N),Y2(N),U(N)
      REAL P, UN
*
      Y2(1) = -0.5
      U(1)  = 3.*(Y(2)-Y(1))
      DO I=2,N-1
        P    = 0.5*Y2(I-1)+2.
        Y2(I)= -0.5/P
        U(I) = (3.*(Y(I+1)-Y(I)-Y(I)+Y(I-1))-0.5*U(I-1))/P
      END DO
      UN = 3.*(-Y(N)+Y(N-1))
      Y2(N) = (UN-0.5*U(N-1))/(0.5*Y2(N-1)+1.)
      DO K = N-1, 1, -1
        Y2(K) = Y2(K)*Y2(K+1)+U(K)
      END DO
      RETURN
      END

      SUBROUTINE SPLY(YA,Y2A,N,X,Y)
*
* Interpolation. Given value X will come back the spline
* interpolated value Y. The routine SPLSET must have been 
* run to setup Y2A beforehand. Extends ends as if value was constant.
*
      IMPLICIT NONE
      INTEGER N, KLO, KHI
      REAL YA(N),Y2A(N)
      REAL A, B, X, Y
*
      IF(X.LT.1.) THEN
        Y = YA(1)
      ELSE IF(X.GT.REAL(N)) THEN
        Y = YA(N)
      ELSE 
        KLO = NINT(X-0.5)
        KHI = KLO+1	
        A = REAL(KHI)-X
        B = X-REAL(KLO)
        Y = A*YA(KLO)+B*YA(KHI)+
     &      ((A**3-A)*Y2A(KLO)+(B**3-B)*Y2A(KHI))/6.
      END IF
      RETURN
      END


      SUBROUTINE SPLD(YA,Y2A,N,X,D)
*
* Interpolation. Given value X will come back the first derivative
* of he pline at X, D. The routine SPLSET must have been run to 
* setup Y2A beforehand. Extends ends as if value was constant.
*
      IMPLICIT NONE
      INTEGER N, KLO, KHI
      REAL YA(N),Y2A(N)
      REAL A, B, X, D
*
      IF(X.LT.1.) THEN
        D = 0.
      ELSE IF(X.GT.REAL(N)) THEN
        D = 0.
      ELSE 
        KLO = NINT(X-0.5)
        KHI = KLO+1	
        A = REAL(KHI)-X
        B = X-REAL(KLO)
        D = YA(KHI)-YA(KLO)-((3.*A**2-1.)*Y2A(KLO)-
     &                       (3.*B**2-1.)*Y2A(KHI))/6.
      END IF
      RETURN
      END
