        SUBROUTINE MNBRAK(AX,BX,CX,FA,FB,FC,FUNC)

* Given a function FUNC, and given distinct initial points AX and BX, this
* routine searches in a downhill direction defined by the function as
* evaluated at the initial points) and returns new points AX, BX, CX
* which bracket a minimum of the function. Also returned are the function
* values at the three points, FA, FB and FC

        IMPLICIT NONE 
        DOUBLE PRECISION AX, BX, CX, FA, FB, FC, FUNC
        DOUBLE PRECISION GOLD, GLIMIT, TINY, DUM, ULIM
        DOUBLE PRECISION FU, U, R, Q
        PARAMETER (GOLD=1.618034, GLIMIT=100., TINY=1.D-20)

        FA = FUNC(AX)
        FB = FUNC(BX)
        IF(FB.GT.FA) THEN
          DUM=AX
          AX=BX
          BX=DUM
          DUM=FB
          FB=FA
          FA=DUM
        END IF
        CX=BX+GOLD*(BX-AX)
        FC=FUNC(CX)
1       IF(FB.GE.FC) THEN
          R=(BX-AX)*(FB-FC)
          Q=(BX-CX)*(FB-FA)
          U=BX-((BX-CX)*Q-(BX-AX)*R)/(2.*SIGN(MAX(ABS(Q-R),TINY),Q-R))
          ULIM=BX+GLIMIT*(CX-BX)
          IF((BX-U)*(U-CX).GT.0.) THEN
            FU=FUNC(U)
            IF(FU.LT.FC) THEN
              AX=BX
              FA=FB
              BX=U
              FB=FU
              GOTO 1
            ELSE IF(FU.GT.FB) THEN
              CX=U
              FC=FU
              GOTO 1
            END IF
            U=CX+GOLD*(CX-BX)
            FU=FUNC(U)
          ELSE IF((CX-U)*(U-ULIM).GT.0.) THEN
            FU=FUNC(U)
            IF(FU.LT.FC) THEN
              BX=CX
              CX=U
              U=CX+GOLD*(CX-BX)
              FB=FC
              FC=FU
              FU=FUNC(U)
            END IF
          ELSE IF((U-ULIM)*(ULIM-CX).GE.0.) THEN
            U=ULIM
            FU=FUNC(U)
          ELSE
            U=CX+GOLD*(CX-BX)
            FU=FUNC(U)
          END IF
          AX=BX
          BX=CX
          CX=U
          FA=FB
          FB=FC
          FC=FU
          GOTO 1
        END IF
        RETURN
        END
