      SUBROUTINE MAINSEQ(M,R,TEFF)
C
C  COMPUTES THE RADIUS (SOLAR RADII) AND EFFECTIVE TEMPERATURE
C  OF A MAIN SEQUENCE STAR OF THE REQUISITE MASS
C  USING DATA FROM ALLEN. (CRUDE)
C
      REAL*4 M,X1(15),X2(15),X3(15)
      DATA X1/
     * -1.00, -0.67, -0.41, -0.33, -0.16
     *,-0.11, -0.03,  0.04,  0.11,  0.23
     *, 0.32,  0.51,  0.81,  1.25,  1.6
     */
      DATA X2/
     * -0.9 , -0.5 , -0.3 , -0.20, -0.13
     *,-0.07, -0.03,  0.02,  0.08,  0.13
     *, 0.24,  0.40,  0.58,  0.87,  1.25
     */
      DATA X3/
     *  2400., 2800., 3200., 3480., 4130.
     *, 4900., 5520., 6030., 6580., 7400.
     *, 8500., 9900.,15500.,28000.,40000.
     */
      IF(M.LE.0.) THEN
      R=0.
      TEFF=0.
      RETURN
      END IF
      XX=ALOG10(M)
      DO 10 I=2,15
      IF(X1(I).GT.XX) GOTO 20
   10 CONTINUE
      I=15
   20 P=(XX-X1(I-1))/(X1(I)-X1(I-1))
      R=10.**(X2(I)*P + X2(I-1)*(1.-P))
      TEFF=10.**(ALOG10(X3(I))*P + ALOG10(X3(I-1))*(1.-P) )
      RETURN
      END

        REAL*4 FUNCTION RADMAIN( MASS )
C
C Function converting from mass to radius for the main
C sequence for masses from .1 to 20 solar masses.
C Data taken from Lacy C.H. (1977) ApJ 34, p479
C Uncertain around the lower end of range. Radii may be consistently
C too small.
C
C REAL*4 MASS -- Mass in solar masses
C REAL*4 RADMAIN -- Radius in solar radii
C
C If MASS is out of range RADMAIN will be set to zero
C
        REAL*4 MASS, SWITCH
        DATA SWITCH/1.293938/
C
        RADMAIN = 0.
        IF( MASS.GT.0. .AND. MASS.LE.SWITCH ) THEN
          RADMAIN = 10.**(0.917*ALOG10( MASS ) - 0.020)
        ELSE IF( MASS .GT.SWITCH .AND. MASS.LT.100.) THEN
          RADMAIN = 10.**(0.640*ALOG10( MASS ) + 0.011)
        END IF
        RETURN
        END
