      SUBROUTINE GBLURR(IMAGE,NX,NY,FWX,FWY,IFAIL)
C
C
C     Written by TRM @STSCI 31/05/90
C     
C     Routine for convolving an image with a gaussian
C     making use of FFTs and convolution theorem for
C     DFTs.
C     This approach is much faster when the amount of
C     spreading (e.g. FWX, FWY the full width half maxima
C     in X and Y) is large. If not it may be better to
C     implement a straightforward convolution.
C
C     The convolution theorem for DFTs says that the DFT
C     of the circular convolution of two series is the
C     product of the DFTs of the individual series.
C     Because it is a circular convolution, one has to add
C     data to avoid overlap between one side of the image
C     and the other. We add data of the same value as the
C     last point of the relevant side, this prevents the
C     edges drooping which would occur if 0 was added.
C
C
C     Inputs:
C     
C     R*4 IMAGE(NX,NY) -- Image to be convolved
C     I*4 NX, NY      -- Dimensions of image
C     R*4 FWX, FWY    -- FWHM of blurring in X and Y
C     
C     Outputs:
C     
C     R*4 IMAGE(NX, NY) - Blurred image
C     I*4 IFAIL       -- Error return. = 0 all ok, = 1 internal
C     work arrays too small
C     
C     Internal works arrays must be greater than or equal to the smallest
C     power of 2 larger than MAX(NX+2*NINT(2.5*FWX),NY+2*NINT(2.5*FWY))
C     It should always be a power of 2 therefore.
C     
C     
      REAL IMAGE(NX,NY), FWX, FWY
      PARAMETER (MXWORK = 4096)
      REAL WORK1(MXWORK), WORK2(MXWORK), EFAC
      DOUBLE PRECISION SUM
C     
      NXADD = 2*NINT(2.5*FWX)
      NXTOT = 2**(INT(LOG(REAL(NX+NXADD))/LOG(2.))+1)
      NYADD = 2*NINT(2.5*FWY)
      NYTOT = 2**(INT(LOG(REAL(NY+NYADD))/LOG(2.))+1)
      IF(NXTOT.GT.MXWORK .OR. NYTOT.GT.MXWORK) THEN
         IFAIL = 1
         RETURN
      END IF
C     
C     First in X. Add pixels to ends to avoid nasty overlap.
C     Find first power of 2 larger than the resulting number.
C     Compute gaussian array, take its Fourier transform
C     Note scaling factor in computation of gaussian to give
C     correct scaling at the end.
C     
      IF(FWX.GT.0.) THEN
         EFAC = 4.*LOG(2.)/FWX**2
         DO I = 1, NXTOT
            WORK2(I) = 0.D0
         END DO
         SUM = 0.D0
         DO I = 1, NXADD/2
            Z = REAL(EXP(-EFAC*DBLE(I-1)**2))
            SUM = SUM + Z
            WORK2(I) = Z
            IF(I.GT.1) THEN
               SUM = SUM + Z
               WORK2(NXTOT+2-I) = Z
            END IF
         END DO
         SUM = SUM*REAL(NXTOT)/2.
         DO I = 1, NXTOT
            WORK2(I) = REAL(WORK2(I)/SUM)
         END DO
         CALL REALFT(WORK2,NXTOT,1)
         N1 = (NXTOT-NX)/2
         DO J = 1, NY
C     
C     Prepare padded array, transform
C     
            DO I = 1, NXTOT
               INEW = MAX(1, MIN(I - N1, NX))
               WORK1(I) = IMAGE(INEW,J)
            END DO
            CALL REALFT(WORK1,NXTOT,1)
C     
C     Multiply FFT by FFT of gaussian
C     Start with first and last frequencies for which
C     the result is real:
C     
            WORK1(1) = WORK1(1)*WORK2(1)
            WORK1(2) = WORK1(2)*WORK2(2)
            DO I = 1, NXTOT/2-1
               I1 = 2*I+1
               I2 = I1+1
               A = WORK2(I1)
               B = WORK2(I2)
               C = WORK1(I1)
               D = WORK1(I2)
               WORK1(I1) = A*C-B*D
               WORK1(I2) = A*D+B*C
            END DO
C     
C     Inverse FFT
C     
            CALL REALFT(WORK1,NXTOT,-1)
C     
C     Load back into data array
C     
            DO I = 1, NX
               IMAGE(I,J) = WORK1(I+N1)
            END DO
         END DO
      END IF
C     
C     Now the same for Y
C     
      IF(FWY.GT.0.) THEN
         EFAC = 4.*LOG(2.)/FWY**2
         DO J = 1, NYTOT
            WORK2(J) = 0.D0
         END DO
         SUM = 0.D0
         DO J = 1, NYADD/2
            Z = REAL(EXP(-EFAC*DBLE(J-1)**2))
            SUM = SUM + Z
            WORK2(J) = Z
            IF(J.GT.1) THEN
               SUM = SUM + Z
               WORK2(NYTOT+2-J) = Z
            END IF
         END DO
         SUM = SUM*REAL(NYTOT)/2.
         DO J = 1, NYTOT
            WORK2(J) = REAL(WORK2(J)/SUM)
         END DO
         CALL REALFT(WORK2,NYTOT,1)
         N1 = (NYTOT-NY)/2
         DO I = 1, NX
C     
C     Prepare padded array, transform
C     
            DO J = 1, NYTOT
               JNEW = MAX(1, MIN(J - N1, NY))
               WORK1(J) = IMAGE(I, JNEW)
            END DO
            CALL REALFT(WORK1,NYTOT,1)
C
C     Multiply FFT by FFT of gaussian
C     Start with first and last frequencies for which
C     the result is real:
C     
            WORK1(1) = WORK1(1)*WORK2(1)
            WORK1(2) = WORK1(2)*WORK2(2)
            DO J = 1, NYTOT/2-1
               J1 = 2*J+1
               J2 = J1+1
               A = WORK2(J1)
               B = WORK2(J2)
               C = WORK1(J1)
               D = WORK1(J2)
               WORK1(J1) = A*C-B*D
               WORK1(J2) = A*D+B*C
            END DO
C     
C     Inverse FFT
C
            CALL REALFT(WORK1,NYTOT,-1)
C
C     Load back into data array
C     
            DO J = 1, NY
               IMAGE(I,J) = WORK1(J+N1)
            END DO
         END DO
      END IF
      IFAIL = 0
      RETURN
      END
