        SUBROUTINE ETUT(IY,IM,ID,DELTAT,DELTA)
C
C PROGRAM TO CONVERT EPHEMERIS TIME TO UT AND UTC(>1971)
C PROGRAM BY JANET WOOD, AUG 1984,
C
C EPOCH MUST BE >1621 AND <1985
C  TO UPDATE ADD MORE ARRAY ELEMENTS TO DT
C
C REAL*4 DELTAT,DELTA
C
C GIVE DATE AND THIS WILL GIVE ET-UT, ET-UTC
C DELTAT = ET - UT, DELTA = ET - UTC
*
* Updated 18/3/1992
C
        INTEGER NTIM, NET
        PARAMETER (NTIM=191, NET=16)
        INTEGER IY,IM,ID
        REAL DT(NTIM),DELTAT,DELTAET(NET),TIME(NTIM)
        REAL ETIME(NET)
C
C
        DATA (DT(I),I=1,100)/98.0,  38.0, -13.0, +13.0, -10.0,
     &  -5.0, -13.5, -12.0,  -7.6,  -2.9,
     &  -0.4,   2.1,   6.6,   8.3,   7.4,
     &   5.7,   4.7,  5.15,  4.64,  5.36,
     &  3.49,  3.27,  2.45,  4.03,  1.76,
     &   3.3,   1.0,  2.42,  0.94,  2.31,
     &  2.27, -0.22,  0.03, -0.05, -0.06,
     & -0.57,  0.03, -0.47,  0.98, -0.86,
     &  2.45,  0.22,  0.37,  2.79,   1.2,
     &  3.52,  1.17,  2.67,  3.06,  2.66,
     &  2.97,  3.28,  3.31,  3.33,  3.23,
     &   3.6,  3.52,  4.27,  2.68,  2.75,
     &  2.67,  1.94,  1.39,  1.66,  0.88,
     &  0.33, -0.17, -1.88, -3.43, -4.05,
     & -5.77, -7.06, -7.36, -7.67, -7.64,
     & -7.93, -7.82, -8.35, -7.91, -8.03,
     & -9.14, -8.18, -7.88, -7.62, -7.17,
     & -8.14, -7.59, -7.17, -7.94, -8.23,
     & -7.88, -7.68, -6.94, -6.89, -7.11,
     & -5.87, -5.04,  -3.9, -2.87,  -.58/
      DATA (DT(I),I=101,191)/0.71, 1.8,  3.08,  4.63, 5.86,
     &  7.21,  8.58,  10.5,  12.1, 12.49,
     & 14.41,1 5.59, 15.81, 17.52, 19.01,
     & 18.39, 19.55, 20.36, 21.01, 21.81,
     & 21.76, 22.35, 22.68, 22.94, 22.93,
     & 22.69, 22.94, 23.20, 23.31, 23.63,
     & 23.47, 23.68, 23.62, 23.53, 23.59,
     & 23.99, 23.8 , 24.2 , 24.99, 24.97,
     & 25.72, 26.21, 26.37, 26.89, 27.68,
     & 28.13, 28.94, 29.42, 29.66, 30.29,
     & 30.96, 31.09, 31.59, 31.52, 31.92,
     & 32.45, 32.91, 33.39, 33.8,  34.23,
     & 34.73, 35.4,  36.14, 36.99, 37.87,
     & 38.75, 39.7,  40.7,  41.68, 42.23,
     & 43.37, 44.49, 45.48, 46.46, 47.52,
     & 48.53, 49.59, 50.54, 51.38, 52.17,
     & 52.96, 53.79, 54.34, 54.87, 55.32,
     & 55.82, 56.30, 56.86, 57.4,  58.0,
     & 58.6/
C
C
C
      DATA (TIME(I),I=1,100)/1621.0,1635.0,1639.0,1645.0,1653.0,
     & 1662.0, 1681.0, 1710.0, 1727.0, 1738.0,
     & 1747.0, 1760.9, 1774.1, 1785.1, 1792.6,
     & 1801.8, 1811.9, 1820.5, 1821.5, 1822.5,
     & 1823.5, 1824.5, 1825.5, 1826.5, 1827.5,
     & 1828.5, 1829.5, 1830.5, 1831.5, 1832.5,
     & 1833.5, 1834.5, 1835.5, 1836.5, 1837.5,
     & 1838.5, 1839.5, 1840.5, 1841.5, 1842.5,
     & 1843.5, 1844.5, 1845.5, 1846.5, 1847.5,
     & 1848.5, 1849.5, 1850.5, 1851.5, 1852.5,
     & 1853.5, 1854.5, 1855.5, 1856.5, 1857.5,
     & 1858.5, 1859.5, 1860.5, 1861.5, 1862.5,
     & 1863.5, 1864.5, 1865.5, 1866.5, 1867.5,
     & 1868.5, 1869.5, 1870.5, 1871.5, 1872.5,
     & 1873.5, 1874.5, 1875.5, 1876.5, 1877.5,
     & 1878.5, 1879.5, 1880.5, 1881.5, 1882.5,
     & 1883.5, 1884.5, 1885.5, 1886.5, 1887.5,
     & 1888.5, 1889.5, 1890.5, 1891.5, 1892.5,
     & 1893.5, 1894.5, 1895.5, 1896.5, 1897.5,
     & 1898.5, 1899.5, 1900.5, 1901.5, 1902.5/
      DATA (TIME(I),I=101,191)/1903.5,1904.5,1905.5,1906.5,1907.5,
     & 1908.5, 1909.5, 1910.5, 1911.5, 1912.5, 
     & 1913.5, 1914.5, 1915.5, 1916.5, 1917.5, 
     & 1918.5, 1919.5, 1920.5, 1921.5, 1922.5, 
     & 1923.5, 1924.5, 1925.5, 1926.5, 1927.5, 
     & 1928.5, 1929.5, 1930.5, 1931.5, 1932.5, 
     & 1933.5, 1934.5, 1935.5, 1936.5, 1937.5,
     & 1938.5, 1939.5, 1940.5, 1941.5, 1942.5, 
     & 1943.5, 1944.5, 1945.5, 1946.5, 1947.5, 
     & 1948.5, 1949.5, 1950.5, 1951.5, 1952.5, 
     & 1953.5, 1954.5, 1955.5, 1956.5, 1957.5, 
     & 1958.5, 1959.5, 1960.5, 1961.5, 1962.5, 
     & 1963.5, 1964.5, 1965.5, 1966.5, 1967.5,
     & 1968.5, 1969.5, 1970.5, 1971.5, 1972.0, 
     & 1973.0, 1974.0, 1975.0, 1976.0, 1977.0, 
     & 1978.0, 1979.0, 1980.0, 1981.0, 1982.0, 
     & 1983.0, 1984.0, 1985.0, 1986.0, 1987.0, 
     & 1988.0, 1989.0, 1990.0, 1991.0, 1992.0, 
     & 1993.0/
C
C
        DATA ETIME/1972.0,1972.5,1973.0,1974.0,1975.0
     &,1976.0,1977.0,1978.0,1979.0,1980.0,1981.5,1982.5
     &,1983.5,1985.5,1988.5,1990.5/
C
C
        DATA DELTAET/42.18,43.18,44.18,45.18,46.18
     &,47.18,48.18,49.18,50.18,51.18,52.18,53.18
     &,54.18,55.18,56.18,57.18/
C
        IFAIL=0
        IF (IY.LT.TIME(1) .OR. IY.GT.TIME(NTIM)) THEN
             WRITE(*,*) CHAR(7),'** EPOCH OUT OF RANGE **'
             RETURN
        ENDIF
        YEAR=REAL(IY)+REAL(IM)/12.
C
C FIND UTC FOR YEAR>1972.0
C
        IF (YEAR.LT.1972.0) THEN
           WRITE(*,*) CHAR(7),
     &     '** EPOCH TOO EARLY FOR UTC,DELTA PUT TO ZERO **'
           UTC=0.
           DELTA=0.
           GOTO 20
        END IF
        DO I=1,NET-1
          IF (YEAR.GE.ETIME(I).AND.YEAR.LT.ETIME(I+1)) GOTO 10
        END DO

C CORRECTION SET EQUAL TO LAST VALUE
C
        WRITE(*,*) CHAR(7),
     &  '** DATE IS AFTER MOST RECENT DATA POINT **'
        WRITE(*,*) '** OF ET-UTC VALUES **'
        WRITE(*,*) 'MOST RECENT POINT IS ',ETIME(NET)
        WRITE(*,*) 'UPDATE SUBROUTINE ''ETUT'' IF YOU WANT'
        I=NET
10      DELTA=DELTAET(I)
20      CONTINUE
C
C ESTABLISH EPOCH RANGE
C
        DO I=1,NTIM-1
           IF (TIME(I).LE.YEAR.AND.TIME(I+1).GT.YEAR) GOTO 30
        END DO
C
C INTERPOLATE TO FIND CORRECTION
C
30      D=DT(I)-DT(I+1)
        D=D/(TIME(I+1)-TIME(I))/365.
        DD=365.*(YEAR-TIME(I))
        DELTAT=DT(I)+DD*D
        RETURN
        END
