        SUBROUTINE DUMP_DAT(FILE,NCOL,NROW,X1,X2,X3,X4,X5,X6,X7)
*
* Dumps arrays into a free-format ascii disk file.
*
* Input:
*       FILE    C* file name or ' ' for interactive selection
*       NCOL    I4 Number of data arrays
*       NROW    I4 Number of data values in each array
*       X1-XNCOL        R4(NROW) The data arrays
*
* Oct 85 by KDH at STScI
* Apr 88 KDH @ STScI - generalized from DUMPMONGO
*
        REAL*4 X1(1), X2(1), X3(1), X4(1), X5(1), X6(1), X7(1)
        CHARACTER*(*) FILE
        CHARACTER*60 INFILE

        IF( NCOL.LT.1 ) RETURN
        IF( NROW.LT.1 ) RETURN

   10 IF( FILE.EQ.' ' ) THEN
        WRITE(*,'(A)') '$Output file : '
        READ(*,'(A)') INFILE
      ELSE
        INFILE = FILE
      END IF
        IF( INFILE.EQ.' ') RETURN

        OPEN( UNIT=93,FILE=INFILE,STATUS='NEW',FORM='FORMATTED',ERR=10 )

      IF( NCOL.EQ.1 ) THEN
      DO I=1,NROW
        WRITE(93,*) X1(I)
      END DO

      ELSE IF( NCOL.EQ.2 ) THEN
      DO I=1,NROW
        WRITE(93,*) X1(I),X2(I)
      END DO

      ELSE IF( NCOL.EQ.3 ) THEN
      DO I=1,NROW
        WRITE(93,*) X1(I),X2(I),X3(I)
      END DO

      ELSE IF( NCOL.EQ.4 ) THEN
      DO I=1,NROW
        WRITE(93,*) X1(I),X2(I),X3(I),X4(I)
      END DO

      ELSE IF( NCOL.EQ.5 ) THEN
      DO I=1,NROW
        WRITE(93,*) X1(I),X2(I),X3(I),X4(I),X5(I)
      END DO

      ELSE IF( NCOL.EQ.6 ) THEN
      DO I=1,NROW
        WRITE(93,*) X1(I),X2(I),X3(I),X4(I),X5(I),X6(I)
      END DO

      ELSE IF( NCOL.EQ.7 ) THEN
      DO I=1,NROW
        WRITE(93,*) X1(I),X2(I),X3(I),X4(I),X5(I),X6(I),X7(I)
      END DO

      END IF
        IF( NCOL.GT.7 ) 
     &  WRITE(*,*) '** DUMP_ASCII: COLUMNS 8-', NCOL,' SKIPPED.'

        PRINT *,'Data dump complete NCOL=', NCOL, ' NROW=', NROW
        CLOSE( UNIT=93 )
        RETURN
        END

C*LOAD_DAT .. load data from multi-column ascii file
C+
      SUBROUTINE LOAD_DAT( NAME, NCOL, NROW,
     #  C1, C2, C3, C4, C5, C6, C7, C8, C9, C10,
     #  C11, C12, C13, C14, C15, C16, C17, C18, C19, C20 )
*
* Loads in up to 20 columns of data from a free-format ASCII data file
*
*  Input:
*       NAME    = C* Name of disk file, ' ' for interactive selection.
*       NCOL    = I4 Number of columns to be read (if NCOL > 0)
*                    (if NCOL < 0, then only column -NCOL is read)
*       NROW    = I4 Maximum allowed number of rows
*  Output:
*       NAME    = C* Name of disk file (only if selected interactively)
*       NROW    = I4 Number of data points (0 if none loaded)
*       C1(NROW)= R4 first column
*       C2(NROW)= R4 second column
*         ...
*       C20(NROW)= R4 last column
C--
* May 1987 Keith Horne @ STScI
* Sep 1987 KDH - add NCOL<0 option to read specified column.
* May 1988 KDH - add final read to pick up eof after reading all rows.
* Jul 1988 KDH @ STScI - change name from LOAD_ASCII to LOAD_DAT
*
        INTEGER INUNIT, MAXCOL
        PARAMETER (INUNIT=49, MAXCOL=20)
        REAL*4 C1(1), C2(1), C3(1), C4(1), C5(1)
        REAL*4 C6(1), C7(1), C8(1), C9(1), C10(1)
        REAL*4 C11(1), C12(1), C13(1), C14(1), C15(1)
        REAL*4 C16(1), C17(1), C18(1), C19(1), C20(1)
        CHARACTER*(*) NAME
        CHARACTER*50 FILE       ! file name
        CHARACTER*128 RECORD    ! buffer into which data are initially read
*
      IF( NROW.LE.0 .OR. NCOL.EQ.0 ) THEN
        PRINT *,'** INVALID DIMENSIONS.', NROW, NCOL
        GOTO 999
      ELSE IF( NCOL.GT.MAXCOL ) THEN
        PRINT *,'** WARNING: Too many columns for LOAD_DAT.'
        PRINT *,'** Columns', MAXCOL, ' thru', NCOL
     !         , ' will not be read.'
      END IF

        MAXROW = NROW

* get name of input file

        FILE = NAME
      IF( FILE.EQ.' ' ) THEN
        PRINT '(1X,A,I3,A)',
     #  'Enter name of', IABS(NCOL),'-column free-format ASCII file :'
        READ(*,'(A)') FILE
        NAME = FILE
      END IF

* open input disk file

        OPEN( UNIT=INUNIT, FILE=FILE, FORM='FORMATTED', STATUS='OLD',
     *  ERR=99)

* read desired column by skipping unwanted columns that precede it.

      IF( NCOL.LE.-2 ) THEN
        NSKIP = IABS(NCOL)-1
      DO I=1,MAXROW
   51   READ( INUNIT, '(A)', ERR=1, END=100 ) RECORD
        READ( RECORD, *, ERR=51, END=51 )
     #  (DUMMY,J=1,NSKIP), C1(I)
      END DO

* read desired consecutive columns of data from the file

      ELSE IF( IABS(NCOL).EQ.1 ) THEN
      DO I=1,MAXROW
    1   READ( INUNIT, '(A)', ERR=1, END=100 ) RECORD
        READ( RECORD, *, ERR=1, END=1 )
     #  C1(I)
      END DO

      ELSE IF( NCOL.EQ.2 ) THEN
      DO I=1,MAXROW
    2   READ( INUNIT, '(A)', ERR=2, END=100 ) RECORD
        READ( RECORD, *, ERR=2, END=2 )
     #  C1(I), C2(I)
      END DO

      ELSE IF( NCOL.EQ.3 ) THEN
      DO I=1,MAXROW
    3   READ( INUNIT, '(A)', ERR=3, END=100 ) RECORD
        READ( RECORD, *, ERR=3, END=3 )
     #  C1(I), C2(I), C3(I)
      END DO

      ELSE IF( NCOL.EQ.4 ) THEN
      DO I=1,MAXROW
    4   READ( INUNIT, '(A)', ERR=4, END=100 ) RECORD
        READ( RECORD, *, ERR=4, END=4 )
     #  C1(I), C2(I), C3(I), C4(I)
      END DO

      ELSE IF( NCOL.EQ.5 ) THEN
      DO I=1,MAXROW
    5   READ( INUNIT, '(A)', ERR=5, END=100 ) RECORD
        READ( RECORD, *, ERR=5, END=5 )
     #  C1(I), C2(I), C3(I), C4(I), C5(I)
      END DO

      ELSE IF( NCOL.EQ.6 ) THEN
      DO I=1,MAXROW
    6   READ( INUNIT, '(A)', ERR=6, END=100 ) RECORD
        READ( RECORD, *, ERR=6, END=6 )
     #  C1(I), C2(I), C3(I), C4(I), C5(I), C6(I)
      END DO

      ELSE IF( NCOL.EQ.7 ) THEN
      DO I=1,MAXROW
    7   READ( INUNIT, '(A)', ERR=7, END=100 ) RECORD
        READ( RECORD, *, ERR=7, END=7 )
     #  C1(I), C2(I), C3(I), C4(I), C5(I), C6(I), C7(I)
      END DO

      ELSE IF( NCOL.EQ.8 ) THEN
      DO I=1,MAXROW
    8   READ( INUNIT, '(A)', ERR=8, END=100 ) RECORD
        READ( RECORD, *, ERR=8, END=8 )
     #  C1(I), C2(I), C3(I), C4(I), C5(I), C6(I), C7(I), C8(I)
      END DO

      ELSE IF( NCOL.EQ.9 ) THEN
      DO I=1,MAXROW
    9   READ( INUNIT, '(A)', ERR=10, END=100 ) RECORD
        READ( RECORD, *, ERR=10, END=10 )
     #  C1(I), C2(I), C3(I), C4(I), C5(I), C6(I), C7(I), C8(I), C9(I)
      END DO

      ELSE IF( NCOL.EQ.10 ) THEN
      DO I=1,MAXROW
   10   READ( INUNIT, '(A)', ERR=10, END=100 ) RECORD
        READ( RECORD, *, ERR=10, END=10 )
     #  C1(I), C2(I), C3(I), C4(I), C5(I), C6(I), C7(I), C8(I), C9(I),
     #  C10(I)
      END DO

      ELSE IF( NCOL.EQ.11 ) THEN
      DO I=1,MAXROW
   11   READ( INUNIT, '(A)', ERR=11, END=100 ) RECORD
        READ( RECORD, *, ERR=11, END=11 )
     #  C1(I), C2(I), C3(I), C4(I), C5(I), C6(I), C7(I), C8(I), C9(I),
     #  C10(I), C11(I)
      END DO

      ELSE IF( NCOL.EQ.12 ) THEN
      DO I=1,MAXROW
   12   READ( INUNIT, '(A)', ERR=12, END=100 ) RECORD
        READ( RECORD, *, ERR=12, END=12 )
     #  C1(I), C2(I), C3(I), C4(I), C5(I), C6(I), C7(I), C8(I), C9(I),
     #  C10(I), C11(I), C12(I)
      END DO

      ELSE IF( NCOL.EQ.13 ) THEN
      DO I=1,MAXROW
   13   READ( INUNIT, '(A)', ERR=13, END=100 ) RECORD
        READ( RECORD, *, ERR=13, END=13 )
     #  C1(I), C2(I), C3(I), C4(I), C5(I), C6(I), C7(I), C8(I), C9(I),
     #  C10(I), C11(I), C12(I), C13(I)
      END DO

      ELSE IF( NCOL.EQ.14 ) THEN
      DO I=1,MAXROW
   14   READ( INUNIT, '(A)', ERR=14, END=100 ) RECORD
        READ( RECORD, *, ERR=14, END=14 )
     #  C1(I), C2(I), C3(I), C4(I), C5(I), C6(I), C7(I), C8(I), C9(I),
     #  C10(I), C11(I), C12(I), C13(I), C14(I)
      END DO

      ELSE IF( NCOL.EQ.15 ) THEN
      DO I=1,MAXROW
   15   READ( INUNIT, '(A)', ERR=15, END=100 ) RECORD
        READ( RECORD, *, ERR=15, END=15 )
     #  C1(I), C2(I), C3(I), C4(I), C5(I), C6(I), C7(I), C8(I), C9(I),
     #  C10(I), C11(I), C12(I), C13(I), C14(I), C15(I)
      END DO

      ELSE IF( NCOL.EQ.16 ) THEN
      DO I=1,MAXROW
   16   READ( INUNIT, '(A)', ERR=16, END=100 ) RECORD
        READ( RECORD, *, ERR=16, END=16 )
     #  C1(I), C2(I), C3(I), C4(I), C5(I), C6(I), C7(I), C8(I), C9(I),
     #  C10(I), C11(I), C12(I), C13(I), C14(I), C15(I),
     #  C16(I)
      END DO

      ELSE IF( NCOL.EQ.17 ) THEN
      DO I=1,MAXROW
   17   READ( INUNIT, '(A)', ERR=17, END=100 ) RECORD
        READ( RECORD, *, ERR=17, END=17 )
     #  C1(I), C2(I), C3(I), C4(I), C5(I), C6(I), C7(I), C8(I), C9(I),
     #  C10(I), C11(I), C12(I), C13(I), C14(I), C15(I),
     #  C16(I), C17(I)
      END DO

      ELSE IF( NCOL.EQ.18 ) THEN
      DO I=1,MAXROW
   18   READ( INUNIT, '(A)', ERR=18, END=100 ) RECORD
        READ( RECORD, *, ERR=18, END=18 )
     #  C1(I), C2(I), C3(I), C4(I), C5(I), C6(I), C7(I), C8(I), C9(I),
     #  C10(I), C11(I), C12(I), C13(I), C14(I), C15(I),
     #  C16(I), C17(I), C18(I)
      END DO

      ELSE IF( NCOL.EQ.19 ) THEN
      DO I=1,MAXROW
   19   READ( INUNIT, '(A)', ERR=19, END=100 ) RECORD
        READ( RECORD, *, ERR=19, END=19 )
     #  C1(I), C2(I), C3(I), C4(I), C5(I), C6(I), C7(I), C8(I), C9(I),
     #  C10(I), C11(I), C12(I), C13(I), C14(I), C15(I),
     #  C16(I), C17(I), C18(I), C19(I)
      END DO

      ELSE IF( NCOL.GE.20 ) THEN
      DO I=1,MAXROW
   20   READ( INUNIT, '(A)', ERR=20, END=100 ) RECORD
        READ( RECORD, *, ERR=20, END=20 )
     #  C1(I), C2(I), C3(I), C4(I), C5(I), C6(I), C7(I), C8(I), C9(I),
     #  C10(I), C11(I), C12(I), C13(I), C14(I), C15(I),
     #  C16(I), C17(I), C18(I), C19(I), C20(I)
      END DO

      END IF
        I = MAXROW + 1

* final read to pick up the eof

        READ( INUNIT, '(A)', ERR=100, END=100 ) RECORD

* give warning if there was data past the final row

        PRINT *, '** WARNING: Data beyond row', MAXROW, ' was not read.'
  100   NROW = I - 1

* close input file

        CLOSE(UNIT=INUNIT)

* normal return

 1000   RETURN

* Error return

   99   PRINT *,CHAR(7),'** Error opening file. ', FILE
        GOTO 999

  999   PRINT *,'** LOAD_DAT aborted.'
        NROW = 0
        RETURN
        END

        SUBROUTINE READ_FREE(DATA, NX, NY, IUNIT, IFAIL)
*
* General purpose routine to read free format real data
* stored in the form of columns.
* It will ignore all blank lines and lines starting with
* an exclamation mark
*
* DATA(NX*NY) -- The data array. NX entries/line, NY lines
* NX -- the number of entries to be read/line. An error will
*       occur if this is too large. Enter a value of zero
*       and the routine will try to determine the number of
*       entries automatically. NX will then be returned.
*       Can be changed on exit.
*
* NY -- the number of lines to be read. Enter 0 to read all
*       the lines. On exit contains the number of lines read
*
* IUNIT -- Reads from IUNIT
*
* IFAIL = 0 Normal exit, anything else an error has occurred.
*
        REAL*4 DATA(1)
        INTEGER*4 NX, NY, IFAIL
        CHARACTER*100 STRING
        LOGICAL BLANK
*
        LENGTH = LEN(STRING)
        IFAIL = 0
        NLINES = 0

* Find number of columns
        IF(NX.LE.0) THEN
          IFAIL = 0
          NBLOCK = 0
          DO WHILE(IFAIL.EQ.0 .AND. NBLOCK.EQ.0)
            STRING(1:1) = '!'
            DO WHILE(STRING(1:1).EQ.'!')
              READ(IUNIT,'(A)',IOSTAT=IFAIL) STRING
            END DO

* Search for number of contiguous blocks of data

            IF(IFAIL.EQ.0) THEN
              NBLOCK = 0
              BLANK = .TRUE.
              DO I = 1, LENGTH
                IF(BLANK .AND. (STRING(I:I).NE.' '
     &                  .AND. STRING(I:I).NE.CHAR(9)) ) THEN
                  NBLOCK = NBLOCK + 1
                  BLANK = .FALSE.
                ELSE IF(.NOT.BLANK .AND. (STRING(I:I).EQ.' ' .OR.
     &                  STRING(I:I).EQ.CHAR(9)) ) THEN
                  BLANK = .TRUE.
                END IF
              END DO
            END IF
          END DO
          IF(IFAIL.NE.0) RETURN

* Translate first line

          NX = NBLOCK
          READ(STRING,*,IOSTAT=IFAIL) (DATA(I),I=1,NX)
          IF(IFAIL.NE.0) RETURN
          NLINES = 1
        END IF

* Read data

        IF(NY.LE.0) NY = 1000000
        DO WHILE(IFAIL.EQ.0 .AND. NLINES.LT.NY)
          READ(IUNIT,'(A)',IOSTAT=IFAIL) STRING
          IF(IFAIL.EQ.0 .AND. STRING(1:1).NE.'!' .AND. 
     &    STRING.NE.' ') THEN
            NLINES = NLINES + 1
            READ(STRING,*,IOSTAT=IFAIL) (DATA(NX*(NLINES-1)+I),I=1,NX)
          END IF
        END DO

* Error check

        IF(IFAIL.GT.0) THEN
          NY = 0
          RETURN
        END IF
        IFAIL = 0
        NY = NLINES
        RETURN               
        END
