      SUBROUTINE ALTAZ(LATIT,LONGIT,RIGASC,
     $                 DECLIN,SIDTIM,ALTIT,AZIMUT)
C
C ARGUMENTS ARE LATITUDE   ) OF OBSERVATION POINT
C               LONGITUDE  ) IN DEGREES.
C               RIGHT ASCENSION IN HOURS
C               DECLINATION IN DEGREES
C               GST IN HOURS
C               ALTITUDE ) IN DEGREES RETURNED
C               AZIMUTH  )
C
C
      REAL*8 LONG,LAT,RA,DEC,GST,HA,WORK,WORK1,WORK2,
     $LATIT,LONGIT,RIGASC,DECLIN,SIDTIM,ALTIT,AZIMUT
C
C
      LAT=LATIT
      LONG=LONGIT
      RA=1.5D1*RIGASC
      DEC=DECLIN
      GST=SIDTIM
C
C HOUR ANGLE IN DEGREES
      HA=1.5D1*GST+LONG-RA
      IF(HA.LT.0.D0)  HA=HA+3.6D2
      IF(HA.GT.3.6D2) HA=HA-3.6D2
C
C
      IF(ABS(ABS(LAT)/9.D1-1.D0).LT.1.D-6) THEN
        ALTIT=DEC
        AZIMUT=-1.D0
        RETURN
      END IF
      WORK=SIND(DEC)*SIND(LAT)+COSD(DEC)*COSD(LAT)*COSD(HA)
      IF(ABS(1.D0-ABS(WORK)).LT.1.D-6) THEN
        ALTIT=9.D1*DBLE(NINT(WORK))
        AZIMUT=-1.D0
        RETURN
      END IF
      WORK2=SQRT(1.D0-WORK*WORK)
      WORK1=(SIND(DEC)-SIND(LAT)*WORK)/COSD(LAT)/WORK2
      ALTIT=ASIND(WORK)
      WORK1=ACOSD(WORK1)
      WORK2=SIND(HA)
      IF(WORK2.GT.0.D0) WORK1=3.6D2-WORK1
      AZIMUT=WORK1
      RETURN
      END
