      SUBROUTINE STPHASE(Q,ANGLE,RADIUS,PHIN,PHEG,IFAIL)
*
* Given mass ratio Q, inclination angle ANGLE and
* a radius/RL1 = RADIUS, this routine returns
* the ingress and egress phases of the eclipse of the stream
* at radius RADIUS by the red star.
*
* If no eclipse, IFAIL = 1
*
      REAL Q, ANGLE, RADIUS, PHIN, PHEG
      REAL X(3), V(3), XO(3)
      REAL*8 DX(3), DV(3), DQ, DSTEP, ACC, DELTA
      LOGICAL YES
      INTEGER NRAD
      PARAMETER (NRAD = 1000)
      REAL XST(NRAD), YST(NRAD), PH1(NRAD), PH2(NRAD)
      DATA QOLD/-10./
      DATA AOLD/-10./
*
* If Q is different from before, compute L1 point and stream.
*
      YES = .FALSE.
      IF(Q.NE.QOLD) THEN
        QOLD = Q
        CALL LAG1( Q, CL1, XL1, IER )
*
* binary center of mass
*
        XCM = Q / ( 1. + Q )
*
* set initial particle position, velocity and time at the L1 point
*
        X(1) = XL1
        X(2) = 0.
        X(3) = 0.
        V(1) = -.01
        V(2) = 0.
        V(3) = 0.
        DO I = 1, 3
          DX(I) = X(I)
          DV(I) = V(I)
        END DO
*
* put first point in the buffer
*
        XST(1) = 1.
        YST(1) = 0.
*
        DQ = Q
        ACC = 1.D-5
        R = 1.
        RMAX = 2.
        IR = 2
        DSTEP = 5.D-3
        RTRIG = REAL(NRAD-IR)/REAL(NRAD-1)
        DO WHILE(R.LE.RMAX)
          XO(1) = X(1)
          XO(2) = X(2)
          ROLD = R
          RMAX = R
*
* integrate the equations of motion in the Roche potential
*
          CALL DSTREAM(DX,DV,DQ,DSTEP,ACC,DELTA)
*
* evaluate particle radius in   units of L1
*
          DO I = 1, 2
            X(I) = DX(I)
          END DO
          RR = X(1)*X(1) + X(2)*X(2)
          R = SQRT(RR)/XL1
*
* Store a point when the radius drops below the trigger value
*
          IF( R.LE.RTRIG ) THEN
            DO  I = 1, 100
              XST(IR) = ((RTRIG-R)*XO(1)+(ROLD-RTRIG)*X(1))
     &        /(ROLD-R)/XL1
              YST(IR) = ((RTRIG-R)*XO(2)+(ROLD-RTRIG)*X(2))
     &        /(ROLD-R)/XL1
              IR = IR + 1
              RTRIG = REAL(NRAD-IR)/REAL(NRAD-1)
              IF(R.GT.RTRIG) GOTO 150
            END DO
150         CONTINUE
          END IF
        END DO
        NUMBER = IR - 1
        YES = .TRUE.
      END IF
*
* Now recompute phases if Q or ANGLE has changed
*
      IF(YES .OR. ANGLE.NE.AOLD) THEN
        AOLD = ANGLE
        X(3) = 0.
        ACC = 0.0001
        DO I = 1, NUMBER
          X(1) = XST(I)
          X(2) = YST(I)
          CALL INEG(ANGLE, Q, X, ACC, PH1(I), PH2(I), IFAIL)
          IF(IFAIL.NE.0) THEN
            NLAST = I - 1
            GOTO 100
          END IF
        END DO
        NLAST = NUMBER
      END IF
*
* PH1 = ingress phase, PH2 = egress phase
* Radius = REAL(NRAD-I)/REAL(NRAD-1). Now interpolate
* to get PHIN, PHEG for this case
*
100   CONTINUE
      Z = REAL(NRAD) - REAL(NRAD-1)*RADIUS
      IF(Z.LT.1. .OR. Z.GT.REAL(NLAST)) THEN
        IFAIL = 1
        RETURN
      END IF
      I1 = INT(Z)
      I2 = I1 + 1
      PHIN = PH1(I1)*(REAL(I2)-Z) + PH1(I2)*(Z-REAL(I1))
      PHEG = PH2(I1)*(REAL(I2)-Z) + PH2(I2)*(Z-REAL(I1))
      IFAIL = 0
      RETURN
      END
