        REAL*8 FUNCTION RPOTL(X,Y,Z,Q)
C
C CALCULATES ROCHE POTENTIAL X,Y,Z CO-ORDINATES IN UNITS OF
C SEPARATION. X MEASURED PRIMARY TO SECONDARY, Y PERPENDICULAR
C TO THIS AND THE ROTATION AXIS, Z ALONG THE ROTATION AXIS
C Q IS MASS RATIO SECONDARY/PRIMARY
C POTENTIAL IS FOR GRAVITATIONAL CONST G=1
C TOTAL MASS OF TWO STARS = 1
C SEPARATION = 1
C IF ERROR RPOTL = 1.
C
        IMPLICIT REAL*8 (A-Z)
C
        TM = 1.D0 + Q
        TM1 = Q / TM
        D = ABS(Y)+ABS(Z)
        IF(ABS(X)+D.LT.1.E-16 .OR. ABS(X-1.D0)+D.LT.1.E-16) THEN
          RPOTL = 1
          RETURN
        END IF
        YY = Y*Y
        ZZ = YY + Z*Z
        RPOTL = -1.D0/TM/SQRT(X*X+ZZ) - TM1/SQRT((1.D0-X)*(1.D0-X)+ZZ)
        RPOTL = RPOTL - TM*((X-TM1)*(X-TM1)+YY)/2.D0
        RETURN
        END
