	SUBROUTINE ROCHEPOT(Q, X, R, D, ICALL)
*
* Evaluates dimensionless Roche potential
* at a point X(3) measured from the centre
* of mass of the primary in units of the
* binary separation. Q = mass ratio = M2/M1
*
* R is the potential, D are the derivatives only
* calculated if ICALL = 1
*
	IMPLICIT NONE
	INTEGER ICALL
	DOUBLE PRECISION Q, X(3), D(3), R, MU
        DOUBLE PRECISION X2Y2, Z2, R11, R1, R2, R22
        DOUBLE PRECISION MU1, COMP, COMP1
*
	MU = Q/(1.D0+Q)
	COMP = 1.D0 - MU
	X2Y2 = X(1)*X(1) + X(2)*X(2)
	Z2 = X(3)*X(3)
 	R1 = X2Y2 + Z2
	R2 = X2Y2 + 1.D0 - 2.D0*X(1) + Z2
	R11 = SQRT(R1)
	R22 = SQRT(R2)
*
* Roche potential
*

	R = - COMP/R11 - MU/R22 - (X2Y2+MU*(MU-2.D0*X(1)))/2.D0
*
* Derivatives
*

	IF(ICALL.EQ.1) THEN
	  COMP1 = COMP/R1/R11
	  MU1   = MU/R2/R22
	  D(1) = COMP1*X(1) + MU1*(X(1)-1.D0) - (X(1)-MU)
	  D(2) = COMP1*X(2) + MU1*X(2) - X(2)
	  D(3) = COMP1*X(3) + MU1*X(3)
	END IF
	RETURN
	END
