	SUBROUTINE POTFIND(Q, R, X0, X1, T1, T, T2, ACC)
*
* Finds point with given Roche potential on
* a specified line X(I) = X0(I) + X1(I)*T , I = 1,3
*
* Inputs REAL*8
*   Q       = Mass ratio = M2/M1.
*   R       the potential to be found.
*   X0(3)   Position of a fixed vector from centre of mass in units
*           of the separation
*   X1(3)   Vector along the direction of the line.
*   T1      Lower limit to T
*   T       is the scalar giving the position of the point.
*   T2      Upper limit to T
*   ACC     the accuracy required in T
*
	IMPLICIT NONE
        EXTERNAL RFUNC
	INTEGER I
	DOUBLE PRECISION Q, R, X0(3), X1(3), T, ACC, T1, T2
        DOUBLE PRECISION RR,QQ, XP0, XP1, RTSAFE
        COMMON/NUM/RR, QQ, XP0(3), XP1(3)
*
        QQ = Q
        RR = R
        DO I = 1, 3
          XP0(I) = X0(I)
          XP1(I) = X1(I)
        END DO
	T = RTSAFE(RFUNC,T1,T2,ACC)
	RETURN
	END

        SUBROUTINE RFUNC(T, F, D)
        IMPLICIT NONE
        INTEGER I
        DOUBLE PRECISION T, F, D, DV(3), X(3)
        DOUBLE PRECISION RR, QQ, XP0, XP1
        COMMON/NUM/RR, QQ, XP0(3), XP1(3)
*
        DO I = 1, 3
          X(I) = XP0(I)+T*XP1(I)
        END DO
        CALL ROCHEPOT(QQ, X, F, DV, 1)
        F = F - RR
        D = 0.D0
        DO I = 1, 3
          D = D + DV(I)*XP1(I)
        END DO
        RETURN
        END
