      SUBROUTINE LAG1(Q,C1,X1,IER)
C  MOCHNACKI ROUTINE FOR LOCATING CRITICAL POINTS OF THE ROCHE POTENTIAL.
        C1=3.9          ! INNER LAGRANGIAN POINT
        X1=0.6
        GOTO 6
      ENTRY LAG2(Q,C1,X1,IER)
        C1=3.5          ! LAGRANGIAN POINT BEHIND SECONDARY STAR
        X1=1.4
        GOTO 6
      ENTRY LAG3(Q,C1,X1,IER)
        C1=3.3          ! LAGRANGIAN POINT BEHIND THE PRIMARY STAR
        X1=-0.5
        GOTO 6
6       CALL XL1(Q,C1,X1,IER)
        RETURN
        END
C
C--------------------------------------------------------------------
      SUBROUTINE XL1(Q,C1,X1,IER)
C     CALCULATION OF INNER & OUTER LAGRANGIAN POINTS, AND CRITICAL POTENTIALS.
      IMAX=15
      EPS=2.E-6
      A0=-2./(1.+Q)
      U=Q/(1.+Q)
      IT=0
      IER=0
    1 IT=IT+1
      XX=X1*X1
      XM=X1-U
      XN=ABS(X1-1.)
      E1=A0/(XX*X1)
      E2=-2.*U/(XN*XN*XN)
      FX=X1*(2.+E1+E2)-E2-2.*U
      D=2.*(1.-E1-E2)
      IF(ABS(D)-EPS)3,3,2
    2 DX=-FX/D
      X1=X1+DX
      CG=ABS(DX)
      IF(IMAX-IT)3,5,5
    5 IF(CG-EPS)4,4,1
    3 IER=1
      RETURN
    4 XM=X1-U
      XN=ABS(X1-1.)
      C1=-A0/X1+2.*U/XN+XM*XM
      RETURN
      END
C
C-------------------------------------------------------
        SUBROUTINE XEND(QIN, CIN, XIN4)
C       EVALUATION OF NON-SINGULAR END-POINTS OF THE ROCHE POTENTIAL.
C       BY S.W. MOCHNACKI
C
C  Input:
C       QIN     = MASS RATIO
C       CIN     = VALUE OF ROCHE POTENTIAL
C       XIN4    = STARTING GUESS FOR X-COORDINATE OF END POINT
C  Output:
C       XIN4    = IMPROVED VALUE OF END POINT
C
C       THIS VERSION 21 MAR 84 FROM DD0 VERSION
C
        IMPLICIT REAL*8 (A-H,O-Z)
        REAL*4 CIN,QIN,XIN4
        C=DBLE(CIN)
        Q=DBLE(QIN)
        XIN=DBLE(XIN4)
      A0=-2./(1.+Q)
      U=Q/(1.+Q)
      IMAX=25
      IT=0
      EPT=1.E-30
        EPS = 5.0E-6 / C
C *** SPECIAL SECTION TO GET APPROXIMATE INITIAL VALUE... BRUTE FORCE.
        DX = -0.03 / C
        IF(XIN.GT.1.0.OR.(XIN.GT.0.0.AND.XIN.LT.0.5)) DX=-DX
        XTEST = 0.
        IF (XIN.GT.0.5) XTEST = 1.0
   10   XTEST = XTEST + DX
        XM = XTEST - U
        XA = 1.0/ABS(XTEST)
        XB = 1.0/ABS(XTEST-1.0)
        F  = -A0*XA + 2.0*U*XB +XM*XM -C
        IF (F.GT.0.)GO TO 10
        XEND8 = XTEST - 0.5*DX
C  NEWTON-RAPHSON ITERATION FOLLOWS.
    1 IT=IT+1
      XM=XEND8-U
      X1=XEND8-1.
      XA=1./ABS(XEND8)
      XB=1./ABS(X1)
      X2=XA*XA
      XT=XB*XB
      F=-A0*XA+2.*U*XB+XM*XM-C
      FX=A0*X2*XA*XEND8-2.*U*X1*XB*XT+2.*XM
      IF(ABS(FX)-EPT)3,3,2
    2 DX=-F/FX
      XEND8=XEND8+DX
      IF(IMAX-IT)3,3,5
    5 IF(ABS(DX)-EPS)4,4,1
    3 XEND8=0.
    4   XIN4 = SNGL(XEND8)
        RETURN
      END
C
C------------------------------------------------------------
        FUNCTION RHO(CIN,QIN,XIN,THIN)
      IMPLICIT REAL*8 (A-H,O-Z)
        REAL*4 CIN,QIN,XIN,THIN,RHO
C     ROCHE CYLINDRICAL RADIUS CALCULATOR.
        C=DBLE(CIN)
        Q=DBLE(QIN)
        X=DBLE(XIN)
        TH=DBLE(THIN)
C  IMPROVED VERSION: AUGUST 1983, IOA.
      IMAX=40
      IC=0
      RHODST=0.5/C
      STH=SIN(TH)
      STH=STH*STH
      RK=1./(1.+Q)
      RL=Q*RK
      RM=X-RL
      RM=RM*RM
C DAMPENED NEWTON-RAPHSON ITERATION.
        RHOD = RHODST
        EPS = RHODST*5.0E-5
        DELMAX = 0.2
C       WRITE(6,400)RHODST,EPS
C 400   FORMAT(' RHO(START)=',F10.6,'  EPS=',1PE14.6)
    1 RR=RHOD*RHOD
      RS=X*X+RR
      RT=RS-2.*X+1.
      R1=SQRT(RS)
      R2=SQRT(RT)
      IC=IC+1
      F = 2.*RK/R1 + 2.*RL/R2 + RM + RR*STH - C
        RS = R1*RS
        RT = R2*RT
        FRHOD = -2.0*RHOD*(RK/RS+RL/RT-STH)
        IF(ABS(FRHOD)-1.0E-30)3,3,4
    4   DEL = -F/FRHOD
        ADEL = MIN(0.8*RHOD,ABS(DEL))
        DEL = SIGN(ADEL,DEL)
        DEL = MIN(DELMAX,DEL)
        RHOD = RHOD + DEL
      IF(IMAX-IC)3,3,5
    5 IF(ADEL-EPS)2,2,1
    3 RHOD=0.
    2   RHO = SNGL(RHOD)
        RETURN
      END
C
C------------------------------------------------------------------------
      SUBROUTINE ROCHE(R,Q2,C)
C
C  EVALUATES DIMENSIONLESS POTENTIAL
C  IN THE ROCHE GEOMETRY
C
      REAL*4 R(3)
      SS=R(2)*R(2)+R(3)*R(3)
      R1=SQRT(R(1)*R(1)+SS)
      X2=R(1)-1.
      R2=SQRT(X2*X2+SS)
      A=1./(1.+Q2)
      XCM=Q2*A
      XP=R(1)-XCM
      PP=R(2)*R(2)+XP*XP
      C=A/R1+XCM/R2
      C=C+C+PP
      RETURN
      END
