        SUBROUTINE INLAG(Q, X, IFAIL)
C
C SUBROUTINE FOR FINDING THE POSITION OF THE INNER LAGRANGIAN POINT
C IN TERMS OF THE SEPARATION OF THE TWO STARS WHICH HAVE MASS RATIO.
C WORKS BY SOLVING FOR ROOT OF A QUINTIC POLYNOMIAL, BY NEWTON-RAPHSON
C Q = (MASS OF SECONDARY) / (MASS OF PRIMARY)
C INLAG IS THEN = (DISTANCE PRIMARY TO INNER LAGRANGIAN)/SEPARTION
C
C PASSED: REAL*8 Q
C RETURNED:REAL*8 X -- ANSWER
C          INTEGER IFAIL = 0 ALL OK, 1 IF ERROR
C
        REAL*8 Q,A(6),D(5),GUESS,X,POLY
C
        NMAX = 1000
        IFAIL = 1
        IF(Q.LT.0) RETURN
C
C SET POLYNOMIAL COEFFICIENTS
        A(1) = -1.
        A(2) =  2.
        A(3) = -1.
        A(4) =  1. + 3.*Q
        A(5) = - 2. - 3.*Q
        A(6) =  1. + Q
C SET DERIVATIVES.
        DO I = 2,6
          D(I-1) = REAL(I-1)*A(I)
        END DO
C
C NEWTON-RAPHSON LOOP
        N = 0
        GUESS = 1. / (1. + Q)
10      X = GUESS - POLY(A,6,GUESS)/POLY(D,5,GUESS)
        N = N + 1
        IF(N.GT.NMAX) RETURN
        IF(ABS((GUESS-X)/X) .GT. 1.D-7) THEN
          GUESS = X
          GOTO 10
        END IF
        IFAIL = 0
        RETURN
        END
