      SUBROUTINE FINDPHI(Q,DEG,DELTA)
*
*  A subroutine to determine the phase width of the eclipse
*  of the center of the accretion disk by the lobe-star.
*
*   Q = M2/M1 IS THE MASS RATIO OF THE BINARY SYSTEM.
*   DEG       IS THE INCLINATION IN DEGREES.
*   DELTA     IS THE ECLIPSE PHASE WIDTH.
*
*  COPYRIGHT JULY 1982 BY KEITH HORNE.
*  MODIFIED OCT 1982 BY KDH.
*  Modified for speed by TRM Jan 1989. It will not work if
*  DELTA is greater than 0.3
*
      LOGICAL BLINK
      REAL*4 E(3),X(3)
      DATA NLOOP/13/
C
      PI=4.*ATAN2(1.,1.)
      ANGLE=DEG*PI/180.
      SINI=SIN(ANGLE)
      COSI=COS(ANGLE)
*
*  The position of the white dwarf center is defined to be the origin.
*
      X(1)=0.
      X(2)=0.
      X(3)=0.
      TRIAL1 = 0.
      E(1)=SINI
      E(2)=0.
      E(3)=COSI
      IF(.NOT. BLINK(X,E,Q)) THEN
*
* No eclipse of white dwarf at all
*
        DELTA = 0.
        RETURN
      END IF
*
* TRIAL2 picked to make sure of white dwarf being out of eclipse.
*
      TRIAL2 = 0.3*PI
*
* Binary chop. Worst case accuracy in value of DELTA = 0.3/2**NLOOP
* = 0.00004 for NLOOP = 13. Average case is 1/2 of this.
*
      DO I=1,NLOOP
*
        TRIAL = (TRIAL1+TRIAL2)/2.
        SINTRIAL=SIN(TRIAL)
        COSTRIAL=COS(TRIAL)
*
*  Unit vector toward earth in the rotating frame of the binary
*  at egress of the disc centre
*
        E(1)= SINI*COSTRIAL
        E(2)=-SINI*SINTRIAL
        E(3)= COSI
*
* Determine whether the white dwarf is occulted at trial phase.
*
        IF(BLINK(X,E,Q)) THEN
*
*  White dwarf is occulted at this phase, move lower
*  limit upwards.
*
          TRIAL1 = TRIAL
        ELSE
*
*  White dwarf is not occulted, move upper limit down
*
          TRIAL2 = TRIAL
        END IF
      END DO
      DELTA = (TRIAL1+TRIAL2)/PI/2.
      RETURN
      END
