        SUBROUTINE DECLIP2(DISC, Q, PHIOUT, INCLIN, IFAIL)
*
* Computes the radius of the disc if it comes out of
* eclipse at phase = PHIOUT, uses a spherical approx.
* INCLIN = inclination, Q = Mass ratio red/white
* DISC = radius scaled by a the separation of the binary
*
* If IFAIL = 0 all OK, otherwise an error has occurred.
*
        REAL*4 DISC, Q, PHIOUT, INCLIN
        INTEGER*4 IFAIL
*
* Set up coefficients of elliptical shadow
* (alpha*x)**2 + (beta*y)**2 = 1. a = 1 throughout
*
        IFAIL = 1
        IF(ABS(PHIOUT).GT.0.25) RETURN
*
* Compute red star radius, Eggleton.
*
        RR = 0.49*(Q**0.6666666)/(0.6*(Q**0.666666)+
     &       LOG(1.+Q**0.3333333))
        BETA = 1./RR
        ALPHA = COSD(INCLIN)*BETA
*
* Position of centre of disc
*
        XC = COSD(360.*PHIOUT)
        YC = SIND(360.*PHIOUT)
*
* Check that centre of disc is not in shadow
*
        C = (ALPHA*XC)**2 + (BETA*YC)**2
        IF(C.LE.1.) RETURN
        IF(ABS(YC).LT.ABS(1./ALPHA-XC)/100.) THEN
          IFAIL = 0
          DISC = ABS(1./ALPHA-XC)
          RETURN
        END IF
        AC = BETA*BETA*XC
        BC = ALPHA*ALPHA*YC
        CC = BETA*BETA - ALPHA*ALPHA
        DC = 1./BETA/BETA
        EC = ALPHA*ALPHA/BETA/BETA
*
* Initial guess at Y
*
        YY = 0.
        YNEW = 1./BETA
*
* Iterate
*
        NITER = 0
        SOFT = 0.
        HARD = 1.
        DO WHILE(ABS((YNEW-YY)*BETA).GT.1.E-6 .AND. NITER.LT.30)
          YY = YNEW
          XX = MIN(1./ALPHA,AC*YY/(BC+CC*YY))
          XX = HARD*XX+SOFT*XOLD
          XOLD = XX
          YNEW = SQRT(DC-EC*XX*XX)
          NITER = NITER + 1
          IF(NITER.GT.5) THEN
            SOFT = 0.8*REAL(NITER)/(20.+REAL(NITER))
            HARD = 1. - SOFT
          END IF
        END DO
        YY = YNEW
        XT = AC*YY/(BC+CC*YY)
        IF(NITER.GE.30 .OR.
     &  ABS((ALPHA*XT)**2+(BETA*YY)**2-1.).GT.1.E-2) THEN
          AC = ALPHA*ALPHA*YC
          BC = BETA*BETA*XC
          CC = BETA*BETA - ALPHA*ALPHA
          DC = 1./ALPHA/ALPHA
          EC = BETA*BETA/ALPHA/ALPHA
*
* Initial guess at X
*
          XX = 0.
          XNEW = 1./ALPHA
*
* Iterate
*
          NITER = 0
          SOFT = 0.
          HARD = 1.
          DO WHILE(ABS((XNEW-XX)*BETA).GT.1.E-6 .AND.NITER.LT.20)
            XX = XNEW
            YY = MAX(0.,MIN(1./BETA,AC*XX/(BC-CC*XX)))
            YY = HARD*YY+SOFT*YOLD
            YOLD = YY
            XNEW = SQRT(DC-EC*YY*YY)
            NITER = NITER + 1
            IF(NITER.GT.5) THEN
              SOFT = 0.8*REAL(NITER)/(20.+REAL(NITER))
              HARD = 1. - SOFT
            END IF
          END DO
          IF(NITER.GE.20) RETURN
          XX = XNEW
        END IF
*
* Compute distance
*
        IFAIL = 0
        DISC = SQRT((XX-XC)**2+(YY-YC)**2)
        RETURN
        END
