        REAL*4 FUNCTION CRITDEG(Q, R)
*
* Input mass ratio and the critical inclination at which
* an eclipse of a disc radius R just occurs. R from 0. to 1.
* R = 0. for white dwarf R in units of L1
* If incorrect parameters are input, -100. is returned.
*
        REAL*4 EARTH(3), X(3), Q, R
        LOGICAL BLINK
*
* Binary chop in the inclination angle
*
        IF(R.LT.0. .OR. R.GE.1.) CRITDEG = - 100.
        ANGLE1 = 0.
        ANGLE2 = 90.
        X(1) = R
        X(2) = 0.
        X(3) = 0.
        EARTH(2) = 0.
        DO WHILE(ANGLE2-ANGLE1.GT.1.E-2)
          ANGLE3 = (ANGLE1+ANGLE2)/2.
          EARTH(1) = SIND(ANGLE3)
          EARTH(3) = SQRT(1.-EARTH(1)*EARTH(1))
          IF(BLINK(X,EARTH,Q)) THEN
            ANGLE2 = ANGLE3
          ELSE
            ANGLE1 = ANGLE3
          END IF
        END DO
        CRITDEG = (ANGLE1+ANGLE2)/2.
        RETURN
        END
