      LOGICAL FUNCTION BLINK(X0,E,Q)
*
*  A logical function subroutine which tests for occultation of
*  a disk location by the lobe-star in a close binary system.
*
*  X0(3) is the position vector (in units of WD to L1)
*        of the location in question.
*  E(3)  is the unit vector toward Earth.
*  Q     is the mass ratio MR/MW.
*
*  Copyright Feb 1982 by Keith Horne
*  This version modified June 85, by T.R. Marsh
*  New version June 1989 by T.R. Marsh to work for
*  all phases and points.
*
        REAL X0(3),E(3)
        DATA QQ/-47./
        DATA CARE/0.01/
        SAVE QQ, XCM, C1, C2, CRIT, XL1, PP, STEP
C
        BLINK = .FALSE.
C
C     Compute geometric (Q dependent) quantities
C
        IF(Q.NE.QQ) THEN
          IF(Q.LE.0.) THEN
            WRITE(6,*) '** Invalid mass ratio in BLINK:',Q
            RETURN
          END IF
          QQ = Q
          XCM = 1./(1.+Q)
          C1 = 2.*XCM
          XCM = Q*XCM
          C2 = 2.*XCM
C
C     Locate the inner Lagrangian point (L1)
C
          CALL LAG1(Q, CRIT, XL1, IER)
C
C     The red star lies entirely within the sphere centred
C     on its centre of mass and reaching the inner Lagrangian
C     point.
C
          RSPHERE = 1.-XL1
          PP = RSPHERE**2
          STEP = RSPHERE*CARE
        END IF
        DX1 = E(1)
        DX2 = E(2)
        DX3 = E(3)
        Z1  = XL1*X0(1)
        Z2  = XL1*X0(2)
        Z3  = XL1*X0(3)
*
* Distance**2 from photon path to centre of red star
* given by L**2 + 2B*L + C where L is a parameter
* giving photon position. 0 at X0
*
        B = DX1*(Z1-1.) + DX2*Z2 + DX3*Z3
        C = (Z1-1.)**2 + Z2*Z2 + Z3*Z3
*
* Photon misses sphere entirely.
*
        FAC = B*B - C + PP
        IF(FAC.LE.0.) RETURN
        FAC = SQRT(FAC)
        PAR1 =  - B - FAC
        PAR2 =  - B + FAC
*
* Photon starts past sphere
*
        IF(PAR2.LE.0.) RETURN
*
* Ensure only positive part of
* path included
*
        PAR1 = MAX(0., PAR1)
*
*  Photon will go inside sphere. We now follow more
*  closely its progress toward Earth to see if it
*  intercepts the red star. We start off at half way
*  point between entry and exit from sphere to increase
*  chance of only needing one computation of Roche potential
*
        PAR = (PAR1+PAR2)/2.
        X1 = Z1 + PAR*DX1
        X2 = Z2 + PAR*DX2
        X3 = Z3 + PAR*DX3
*
* Test Roche potential for an occultation
*
        YY = X2*X2
        RR = YY + X3*X3
        RS1 = X1*X1 + RR
        R1 = SQRT(RS1)
        XM = X1 - 1.
        RS2 = XM*XM + RR
*
* Point at C of M of red star. Definitely eclipsed
*
        IF(RS2.LE.0.) GOTO 20
        R2 = SQRT(RS2)
        XC = X1 - XCM
        C = C1/R1 + C2/R2 + XC*XC + YY
*
* Deeper in well than inner Lagrangian,
* therefore eclipsed.
*
        IF(C.GT.CRIT) GOTO 20
*
* Now need to step. Determine step direction
* by evaluating the first derivative
*
        A = X1*DX1 + X2*DX2
        B = A + X3*DX3
        FDERIV = -C1*B/RS1/R1-C2*(B-DX1)/RS2/R2+2.*(A-XCM*DX1)
        IF(FDERIV.GT.0.) THEN
          P1 = PAR
          P2 = PAR2
        ELSE
          P1 = PAR
          P2 = PAR1
        END IF
*
* Loop while the Roche potential
* is increasing
*
        NSTEP = MAX(2,NINT(ABS(P2-P1)/STEP))
        DP = (P2-P1)/REAL(NSTEP)
        DO I = 1, NSTEP
          CMAX = C
          P = P1  + DP*REAL(I)
          X1 = Z1 + P*DX1
          X2 = Z2 + P*DX2
          X3 = Z3 + P*DX3
*
* Test Roche potential for an occultation
*
          YY = X2*X2
          RR = YY + X3*X3
          R1 = SQRT(X1*X1 + RR)
          XM = X1 - 1.
          R2 = SQRT(XM*XM + RR)
          IF(R2.LE.0.) GOTO 20
          XC = X1 - XCM
          C = C1/R1 + C2/R2 + XC*XC + YY
          IF(C.GT.CRIT) GOTO 20
          IF(C.LT.CMAX) RETURN
        END DO
        RETURN
*
* The photon is captured!
*
20      BLINK = .TRUE.
        RETURN
        END

