C* PGSLUT ... edit the look-up table for false-color on displayed image
C+
      SUBROUTINE PGSLUT
*
* Interactive manipulation of look-up-tables for false-color on image displays.
* The color look-up table is a spiral in color space.
* The user controls the intensity, hue and saturation
* at the beginning and end of the spiral, and the number of times
* the spiral is repeated.  The look-up table can be inverted.
* Look-up tables can also be saved in and recalled from disk files.
C--
* Oct 1986 KDH @ STScI - adapted from palset
* Feb 1987 KDH @ STScI - implement IMGUNW
* Feb 1988 Keith Horne @ STScI - adapted from IMCOLOR for pgplot
* Apr 1988 KDH @ STScI - make wedge optional, default scale on first call only
* Nov 1988 KDH @ STScI - eliminate TYPE *, use PGQIMG.
* May 90 KDH @ STScI - PGUPDT after each change
*
      IMPLICIT NONE
      INTEGER MAXLEVELS
      PARAMETER (MAXLEVELS=256)
      REAL GUN(MAXLEVELS,3)
      REAL TWOPI, DSAT1, SAT1, BRT1, BRT2, DBRT1, DBRT2
      REAL PART, VALUE, VAL1, VAL2, BRT, SAT, PHASE
      REAL RADIAN, HOLD, SAT2, DSAT2, ROUNDS, DROUNDS
      REAL HUE1, DHUE1, HRANGE, DHRANGE
      INTEGER MINCI, MAXCI, NCI, I, IPART, IGUN, J
      LOGICAL COLOR, INVERT, FIRSTCALL
      CHARACTER*1 REPLY
      CHARACTER*70 FILE
      DATA DROUNDS/1./               ! NUMBER OF ROUNDS
      DATA DHUE1,DHRANGE/1.,6./      ! FIRST HUE AND RANGE
      DATA DSAT1,DSAT2/1.,6./        ! SATURATION LIMITS
      DATA DBRT1,DBRT2/.6,1.1/       ! LUMINOSITY LIMITS
      DATA COLOR/.TRUE./             ! COLORS ON
      DATA INVERT, FIRSTCALL/.FALSE.,.TRUE./
*
      TWOPI = ATAN2(1.,1.)*8.
*
* ABORT IF device is not an image display
*
      CALL PGQCOL( MINCI, MAXCI )
      MINCI = MINCI + 16
      NCI = MAXCI - MINCI + 1
      IF( NCI.LE.1 ) THEN
        WRITE(*,*) '** NOT AN IMAGE DISPLAY DEVICE.'
        GOTO 999
      ELSE IF( NCI.GT.MAXLEVELS ) THEN
        WRITE(*,*) '** WARNING: NCI=', NCI, ' max=', MAXLEVELS
        MAXCI = MINCI + MAXLEVELS - 1
        NCI = MAXCI - MINCI + 1
      END IF
*
* preliminaries
*
      IF( FIRSTCALL ) THEN
        FIRSTCALL = .FALSE.
        GOTO 60
      END IF
*
* command list
*
10    WRITE(*,*) 'PGSLUT command menu:'
      WRITE(*,*) '  W ... show WEDGE for calibration'
      WRITE(*,*) '  B ... BACK to default color scale'
      WRITE(*,*) '  G ... GREYSCALE (colors off)'
      WRITE(*,*) '  C ... COLORS on'
      WRITE(*,*) '  V ... INVERT color scale'
      WRITE(*,*) '  R ... set number of ROUNDS'
      WRITE(*,*) '  I ... set INTENSITY limits'
      WRITE(*,*) '  S ... set SATURATION limits'
      WRITE(*,*) '  H ... set HUES limits'
      WRITE(*,*) '  D ... DUMP color table to disk file.'
      WRITE(*,*) '  L ... LOAD color table from disk file.'
      WRITE(*,*) '  Q ... QUIT'
*
* command node
*
20    WRITE(*,'(A)') '$PGSLUT > '
      READ(*,'(A)') REPLY
      CALL UPPER_CASE( REPLY )
*
      IF(REPLY.EQ.'Q') RETURN
      IF(REPLY.EQ.'W') GOTO 50
      IF(REPLY.EQ.'B') GOTO 60
      IF(REPLY.EQ.'G') GOTO 1000
      IF(REPLY.EQ.'C') GOTO 2000
      IF(REPLY.EQ.'R') GOTO 3000
      IF(REPLY.EQ.'I') GOTO 4000
      IF(REPLY.EQ.'S') GOTO 5000
      IF(REPLY.EQ.'H') GOTO 6000
      IF(REPLY.EQ.'V') GOTO 7000
      IF(REPLY.EQ.'D') GOTO 8000
      IF(REPLY.EQ.'L') GOTO 8100
      GOTO 10
*
* Paint plain calibration wedge
*
50    CALL PGWEDGE(0.,0.,2)
      GOTO 20
*
* Set default color scale parameters
*
60    ROUNDS = DROUNDS
      HUE1 = DHUE1
      HRANGE = DHRANGE
      SAT1 = DSAT1
      SAT2 = DSAT2
      BRT1 = DBRT1
      BRT2 = DBRT2
      INVERT = .FALSE.
      COLOR = .TRUE.
      IF(COLOR) GOTO 2000
      GOTO 1000
*
* Set palette to a simple greyscale
*
1000  WRITE(*,*) 'Greyscale parameters:'
      WRITE(*,*) '    ROUNDS =',ROUNDS
      WRITE(*,*) ' INTENSITY =',BRT1,' TO',BRT2
      DO I=1,NCI
        PART = ROUNDS*(I-1.)/FLOAT(NCI)
        IPART= PART
        PART = PART-IPART
        VALUE = BRT1*(1.-PART) + BRT2*PART
        DO IGUN=1,3
          GUN(I,IGUN) = MAX(0., MIN(1., VALUE ) )
        END DO
      END DO
*
* set extreme values to white and black
*
      IF(INVERT) THEN
        DO IGUN=1,3
          GUN(NCI,IGUN) = 0.
          GUN(1,IGUN) = 1.
        END DO
      ELSE
        DO IGUN=1,3
          GUN(NCI,IGUN) = 1.
          GUN(1,IGUN) = 0.
        END DO
      END IF
      COLOR=.FALSE.
      GOTO 1500
*
* Construct a color spiral palette
*
2000  WRITE(*,*) 'Color Spiral parameters:'
      WRITE(*,*) ' ROUNDS=',ROUNDS
      WRITE(*,*) '   INT =',BRT1,' TO',BRT2
      WRITE(*,*) '   SAT =',SAT1,' TO',SAT2
      WRITE(*,*) '   HUE =',HUE1,' RANGE',HRANGE
      DO I=1,NCI
        PART = ROUNDS*(I-1.)/(NCI-1.)
        IPART = PART
        PART = PART-IPART
        BRT = BRT1*(1.-PART) + BRT2*PART
        SAT = SAT1*(1.-PART) + SAT2*PART
        PHASE = (HUE1 - HRANGE*PART)/6.
        DO IGUN=1,3
          RADIAN = TWOPI*( PHASE - (IGUN-1.)/3. )
          VALUE = BRT + SAT*( 0.5*(1.+COS(RADIAN)) -1.)
          GUN(I,IGUN) = MAX(0., MIN(1., VALUE ) )
        END DO
      END DO
*
* set extreme values to white and black
*
      IF(INVERT) THEN
        DO IGUN=1,3
          GUN(NCI,IGUN) = 0.
          GUN(1,IGUN) = 1.
        END DO
      ELSE
        DO IGUN=1,3
          GUN(NCI,IGUN) = 1.
          GUN(1,IGUN) = 0.
        END DO
      END IF
      COLOR=.TRUE.
      GOTO 1500
*
* set number of rounds
*
3000  WRITE(*,*) 'Current number of rounds is', ROUNDS
      WRITE(*,*) 'How many rounds do you want ?'
      READ(*,*,ERR=10) ROUNDS
      IF(COLOR) GOTO 2000
      GOTO 1000
*
* Set brilliance limits
*
4000  WRITE(*,*) 'Enter (1) Intensity (0-1) at bottom of scale'
      WRITE(*,*) '      (2) Intensity at top of scale'
      READ(*,*,ERR=10) VAL1,VAL2
      BRT1=VAL1
      BRT2=VAL2
      IF(COLOR) GOTO 2000
      GOTO 1000
*
* Set saturation limits
*
5000  WRITE(*,*)
     &'Saturation (0-1) measures the intensity of the colors.'
      WRITE(*,*) 'Enter (1) Saturation at bottom of scale'
      WRITE(*,*) '      (2) Saturation at top of scale'
      READ(*,*,ERR=10) VAL1,VAL2
      SAT1=VAL1
      SAT2=VAL2
      IF(COLOR) GOTO 2000
      GOTO 1000
*
* Set hue limits
*
6000  WRITE(*,*) 'COLOR: RED pur BLU aqu GRN yel'
      WRITE(*,*) 'INDEX:  0   1   2   3   4   5'
      WRITE(*,*) '        6   7   8   9  10  11'
      WRITE(*,*) '       12  13  14  15  16  17 ...'
      WRITE(*,*) 'Enter (1) INDEX at bottom of color scale'
      WRITE(*,*) '      (2) INDEX at  top   of color scale'
      READ(*,*,ERR=10) VAL1,VAL2
      HUE1=VAL1
      HRANGE=VAL2-VAL1
      IF(COLOR) GOTO 2000
      GOTO 1000
*
* Invert color scale
*
7000  HOLD = BRT1
      BRT1 = BRT2
      BRT2 = HOLD
      HOLD = SAT2
      SAT2 = SAT1
      SAT1 = HOLD
      HUE1 = HUE1 - HRANGE
      HRANGE = - HRANGE
      INVERT = .NOT. INVERT
      IF(COLOR) GOTO 2000
      GOTO 1000
*
* DUMP look-up table
*
8000  WRITE(*,*) 'Name of look-up table save file ? '
      READ(*,'(A)') FILE
      OPEN( UNIT=48, FILE=FILE, STATUS='NEW', FORM='FORMATTED',
     $      ERR=8030 )
      WRITE(*,*) 'LUT save file opened.'
      DO I=1,MAXLEVELS
        WRITE( 48, *, ERR=8020 ) (GUN(I,J), J=1,3)
      END DO
      WRITE(*,*) 'Values dumped=', MAXLEVELS
8010  CLOSE( UNIT=48 )
      WRITE(*,*) 'LUT save file closed.'
      GOTO 20
8020  WRITE(*,*) '** Read error.'
      GOTO 8010
8025  WRITE(*,*) '** Premature end of file.'
      GOTO 8010
8030  WRITE(*,*) '** Open error.'
      GOTO 20
*
* LOAD look-up table
*
8100  WRITE(*,*) 'Name of look-up table input file ? '
      READ(*,'(A)') FILE
      OPEN( UNIT=48, FILE=FILE, STATUS='OLD', FORM='FORMATTED',
     $      ERR=8030)
      WRITE(*,*) 'LUT input file opened.'
      DO I=1,MAXLEVELS
        READ( 48, *, ERR=8020, END=8025 ) (GUN(I,J), J=1,3)
      END DO
      CLOSE( UNIT=48 )
      WRITE(*,*) 'LUT save file closed.'
      GOTO 1500
*
* Load the guns
*
1500  J = 0
      CALL PGBBUF
      DO I=MINCI, MAXCI
        J = J + 1
        CALL PGSCR( I, GUN(J,1), GUN(J,2), GUN(J,3) )
      END DO
      CALL PGEBUF
      CALL PGUPDT
      GOTO 20
*
* error return
*
999   WRITE(*,*) '** PGSLUT aborted.'
      RETURN

      END

