	SUBROUTINE MEMCORE(MXBUF, NXPIX, NYPIX, NZPIX, NOBS, IER)
C
C  FORMATS MEMSYS CORE BUFFER FOR IMAGES AND DATA VECTORS
C
C  Input:
C	MXBUF	= MAXIMUM ALLOWED NUMBER OF 4-BYTE SLOTS IN STORAGE BUFFER
C	NXPIX	= X DIMENSION OF IMAGES
C	NYPIX	= Y DIMESNION OF IMAGES
C	NZPIX	= Z DIMENSION OF IMAGES
C  Output:
C	IER	= 1 IF REQUIRED DIMENSIONS OVERFLOW MXBUF, 0 OTHERWISE.
C
C  FEB 1984 BY KDH AT IOA
C
	COMMON/MECOMP/NJ,MJ,NK,MK,KA(40),KB(40),KC(40),KD(40),
     *IOUT,L0,L1,M0,M1,M2,M3,M4
C
	INTEGER*4 JFILE(20),KFILE(20)

	DATA JFILE/
* simple arrangement allocates too much space; not all images are used
*    * 1, 2, 3, 4, 5, 6, 7, 8, 9,10,11,12,13,14,15,16,17,18,19,20/
* image storage arrangement for old version of memsys, obsolete as of dec 85
*    * 1, 1, 2, 3, 4, 5, 3, 4, 5, 6, 7, 6, 7, 0, 0, 0, 0,10, 8, 9/
* image store for Dec 85 version of memsys (uses 8 images)
     * 1, 2, 3, 4, 5, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9, 7, 8/
* Note: image vector 18 may be used as a scratch area

	DATA KFILE/
* data vectors are numbered from 21 up
*    *21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40/
* data store for pre-Dec 85 version of memsys
*    * 1, 2, 3, 3, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 5, 0, 0, 0, 0, 0/
* data store for Dec 85 version of memsys (uses 8 data vectors)
     * 1, 2, 3, 4, 5, 6, 7, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0/
	DATA MXJFILE,MXKFILE/20,20/
C
	TYPE *,' '
	TYPE *,'FORMATTING CORE STORAGE FOR DATA AND IMAGE VECTORS.'
	TYPE *,'IMAGE DIMENSION (X,Y,Z)=',NXPIX,NYPIX,NZPIX
	TYPE *,' DATA DIMENSION =',NOBS
C
C  LOAD IMAGE POINTERS
C
   25	NJ=1
	MJ=NXPIX*NYPIX*NZPIX
	NJFILE=0
	KORE=0
      DO I=1,MXJFILE
	KB(I)=-9999999
      IF(JFILE(I).GT.0) THEN
	NJFILE=NJFILE+1
	KB(I)=(JFILE(I)-1)*NJ*MJ + 1
	KORE=MAX(KORE,KB(I))
      END IF
      END DO
	KOREJ=KORE + NJ*MJ - 1
C
C  LOAD DATA POINTERS
C
	NK=1
	MK=NOBS
	NKFILE=0
      DO I=1,MXKFILE
	KB(MXJFILE+I)=-9999999
      IF(KFILE(I).GT.0) THEN
	NKFILE=NKFILE+1
	KB(MXJFILE+I)=KOREJ + (KFILE(I)-1)*NK*MK+1
	KORE=MAX(KORE,KB(MXJFILE+I))
      END IF
      END DO
C
C  SUMMARIZE STORAGE REQUIREMENTS ON TERMINAL
C
	KORE = KORE + NK*MK - 1
	KOREK= KORE - KOREJ
	NIMAGES=KOREJ/(NJ*MJ)
	NDATAS =KOREK/(NK*MK)
	TYPE *,NJFILE,' IMAGES IN',NIMAGES,' FILES'
	TYPE *,(KB(I),I=1,MXJFILE)
	TYPE *,NKFILE,' DATA VECTORS IN',NDATAS,' FILES'
	TYPE *,(KB(I),I=MXJFILE+1,MXJFILE+MXKFILE)
	NTEST = KB(NJFILE+MXKFILE) + NK*MK
	TYPE *,'IMAGE STORE:',KOREJ,' =',FLOAT(KOREJ)/KORE*100.,' %'
	TYPE *,' DATA STORE:',KOREK,' =',FLOAT(KOREK)/KORE*100.,' %'
	TYPE *,'TOTAL STORE:',KORE,' =',FLOAT(KORE)/MXBUF*100.,' %'
     *	,' OF BUFFER:',MXBUF
C
C  BUFFER OVERFLOWS
C
      IF(KORE .GT. MXBUF) THEN
	TYPE *,CHAR(7),'STORAGE REQUIREMENTS OVERFLOW THE BUFFER:',KORE,MXBUF
	IER = 1
	RETURN
      END IF
C
C  NORMAL RETURN
C
	IER = 0
	RETURN
	END
