      SUBROUTINE XSCAL
*
* XSCAL
*
* Written by T.R. Marsh, adds X axis scale to FIGARO
* data file, trailed spectrum format.
*
* FIGARO variables:
*
* IMAGE   -- Data file containing data and HJDs
*
* VSCALE  -- True for velocity scale, false for wavelength
*
* CENWAVE -- Central wavelength to measure V from if VSCALE
*
      IMPLICIT NONE
*
      INTEGER DYN_ELEMENT
      INCLUDE 'DYN_SOURCE:DYNAMIC_MEMORY.INC'
*
* Functions
*
      INTEGER ICH_LEN
*
* Local variables
*
      INTEGER STATUS, DTA_STATUS, METHOD
      INTEGER ADDRESS, SLOT
      INTEGER IPIN1, IPIN2, IPIN3, IPIN4, IPIN5
      INTEGER DIMS1(3), DIMS2(2)
      CHARACTER*32 IMAGE, OUTPUT
      CHARACTER*32 CMPNAM, IMCOMP, SPCOMP, TYPE*16
      CHARACTER*40 UNITS
      LOGICAL EXIST, HMAP, VSCALE
      INTEGER NDIMS1, NDIMS2, NELM, LFILE, IPOS
      INTEGER I, IFAIL, J, IEFIND, ICFIND, NMSTAT
      INTEGER NX, NY, NARC
      REAL*8 ARC
      CHARACTER*80 STRING
      INTEGER NC
      CHARACTER*32 UNIT_LABEL(2)
      REAL*8 DUM
      REAL CENWAVE
*
* Flags for DSA_OUTPUT
*
      INTEGER NO_DATA, NEW_FILE
      PARAMETER (NO_DATA=1, NEW_FILE=1)
*
* Initialise system
*
      STATUS = 0
      HMAP = .FALSE.
      CALL DSA_OPEN(STATUS)
*
* Open input file
*
      CALL DSA_INPUT('IMAGE', 'IMAGE', STATUS)
*
* Get size of data array
*
      CALL DSA_DATA_SIZE('IMAGE',2,NDIMS1,DIMS1,NELM,STATUS)
      IF(NDIMS1.NE.1 .AND. NDIMS1.NE.2) THEN
        CALL PAR_WRUSER('Invalid number of dimensions',STATUS)
        GOTO 999
      END IF
      NX = DIMS1(1)
      CALL DTA_RDVARI('IMAGE.HEAD.NARC',1,NARC,STATUS)
      IF(STATUS.NE.0) NARC = - 2
      NC = ABS(NARC)
      CALL DTA_RDVARD('IMAGE.HEAD.ARC',NC,ARC,STATUS)
      IF(STATUS.NE.0) THEN
        CALL PAR_WRUSER('Could not read ARC coefficients', STATUS)
        GOTO 999
      END IF
      CALL PAR_RDKEY('VSCALE', .TRUE., VSCALE)
      IF(VSCALE) THEN
        CALL PAR_RDVAL('CENWAVE',1.,1.E10,5000.,' ',CENWAVE)
        UNIT_LABEL(1) = 'km/s'
        UNIT_LABEL(2) = 'Velocity'
      ELSE
        UNIT_LABEL(1) = '\aa'
        UNIT_LABEL(2) = 'Wavelength'
      END IF
      CALL DSA_COERCE_AXIS_DATA('IMAGE',1,'FLOAT',1,NX,STATUS)
      CALL DSA_SET_AXIS_INFO('IMAGE',1,2,UNIT_LABEL,0,DUM,STATUS)
*
* Map axis data 
*
      CALL DSA_MAP_AXIS_DATA('IMAGE',1, 'UPDATE','FLOAT',
     &ADDRESS,SLOT,STATUS)      
      IPIN1 = DYN_ELEMENT(ADDRESS)
*
      CALL XSCALER(DYNAMIC_MEM(IPIN1), NX, VSCALE, CENWAVE, ARC, NARC)
*
*     Tidy up
*
999   CONTINUE
      CALL DSA_CLOSE(STATUS)
      RETURN
      END	


      SUBROUTINE XSCALER(DATA, NX, VSCALE, CENWAVE, ARC, NARC)
*
* Sets array XDATA according to arc coefficients in ARC(NARC)
*
      REAL DATA(NX), CENWAVE, CGS, VLIGHT
      REAL*8 ARC(1), POLY, X
      LOGICAL VSCALE
*
      NCOFF = ABS(NARC)
      IF(VSCALE) THEN
        VLIGHT = CGS('C')/1.E5
        CWLOG  = LOG(CENWAVE)
        DO I = 1, NX
          X = DBLE(I)/DBLE(NX)
          WAVE = POLY(ARC, NCOFF, X)
          IF(NARC.LT.0) THEN
            DATA(I) = VLIGHT*(WAVE-CWLOG)
          ELSE
            DATA(I) = VLIGHT*(LOG(WAVE)-CWLOG)
          END IF
        END DO
      ELSE
        DO I = 1, NX
          X = DBLE(I)/DBLE(NX)
          WAVE = POLY(ARC, NCOFF, X)
          IF(NARC.LT.0) THEN
            DATA(I) = EXP(WAVE)
          ELSE
            DATA(I) = WAVE
          END IF
        END DO
      END IF
      RETURN
      END
