      SUBROUTINE SETERR
*
* SETERR
*
* Written by T.R. Marsh, changes error bars in
* particular parts of data. Can be used to ignore
* different regions of data. This done by identifying
* a region of an IMAGE to ignore. This is then transferred
* into data space.
*
*
* FIGARO variables:
*
* IMAGE    -- The image file to get wavelengths etc from
*
* DATA     -- Data file containing error array
*
* OUTPUT   -- Calculated data with altered error bars.
*
* XCEN     -- X centre of region of image to ignore
*
* YCEN     -- Y centre of region of image to ignore
*
* RADIUS   -- Radius of region to ignore
*
* SHIFT    -- Optional offset, useful for bad regions such as "everything
*             blue of 2000 km/s"
*
* FACtOR   -- All error bars in affected region are multiplied by this.
*
*
      IMPLICIT NONE
*
* Functions
*
      INTEGER ICH_LEN
      REAL CHISQR
*
* Local variables
*
      INTEGER STATUS
      INTEGER DIMS1(3), DIMS2(2)
      CHARACTER*32 IMAGE, DATA, OUTPUT
      CHARACTER*32 CMPNAM, IMCOMP, SPCOMP, TYPE*16
      LOGICAL IOPEN, OOPEN, OMAP1, OMAP2, FAULT, DOPEN
      INTEGER NDIMS1, NDIMS2, NELM, LFILE, IPOS, NSIDE
      INTEGER I, IFAIL, J, IEFIND, ICFIND, NMSTAT, NPIX
      INTEGER NITS, NUPDAT, NDEF, NBLOCK, NSTAT, NIMAGE
      INTEGER NSPEC
      REAL XCEN, YCEN, RADIUS, OFFSET, VPIX, SHIFT, FACTOR
      REAL WAVE(5), GAMMA
      REAL*8 ARC(2)
      CHARACTER*80 STRING
      INTEGER IPIN1, IPIN2
*
* Initialise logical flags
*
      FAULT = .TRUE.
      IOPEN  = .FALSE.
      OOPEN  = .FALSE.
      OMAP1  = .FALSE.
      OMAP2  = .FALSE.
*
* Get image region output file 
*
      CALL PAR_RDCHAR('IMAGE',' ',IMAGE)
      CALL DTA_ASFNAM('IMAGE',IMAGE(:ICH_LEN(IMAGE))//'.DST',
     &           'OLD',0,' ',STATUS)
      IF (STATUS.NE.0) THEN
         CALL FIG_DTAERR(STATUS,'Unable to open IMAGE file')
         GOTO 999
      END IF
      IOPEN = .TRUE.
*
*     Get size of data array
*
      CALL DTA_SZVAR('IMAGE.Z.DATA',10,NDIMS1,DIMS1,STATUS)
      IF (STATUS.NE.0) THEN
         CALL FIG_DTAERR(STATUS,'Unable to get dimensions of frame')
         GOTO 999
      END IF
      IF(NDIMS1.NE.2 .AND. NDIMS1.NE.3) THEN
        CALL WRUSER('Invalid number of dimensions',STATUS)
        GOTO 999
      END IF
      NSIDE = DIMS1(1)
      IF(NDIMS1.EQ.3) THEN
        NIMAGE = DIMS1(3)
      ELSE
        NIMAGE = 1
      END IF
*
* Read wavelengths
*
      CALL DTA_RDVARF('IMAGE.HEAD.WAVE',NIMAGE,WAVE,STATUS)
      IF(STATUS.NE.0) THEN
        CALL PAR_WRUSER('Could not read rest wavelengths', STATUS)
        GOTO 999
      END IF
      CALL DTA_RDVARF('IMAGE.HEAD.GAMMA',1,GAMMA,STATUS)
      IF(STATUS.NE.0) THEN
        CALL PAR_WRUSER('Could not read GAMMA', STATUS)
        GOTO 999
      END IF
      CALL DTA_RDVARF('IMAGE.HEAD.OFFSET',1,OFFSET,STATUS)
      IF(STATUS.NE.0) THEN
        CALL PAR_WRUSER('Could not read OFFSET', STATUS)
        GOTO 999
      END IF
*
* Open data file to provide phases, wavelength scale etc
* for computed data
*
      CALL PAR_RDCHAR('DATA',' ',DATA)
      CALL DTA_ASFNAM('DATA',DATA(:ICH_LEN(DATA))//'.DST',
     &           'OLD',0,' ',STATUS)
      IF (STATUS.NE.0) THEN
         CALL FIG_DTAERR(STATUS,'Unable to open data file')
         GOTO 999
      END IF
      DOPEN = .TRUE.
*
*     Get size of ERRORS
*
      CALL DTA_SZVAR('DATA.Z.ERRORS',10,NDIMS2,DIMS2,STATUS)
      IF (STATUS.NE.0) THEN
         CALL FIG_DTAERR(STATUS,'Unable to get dimensions of errors')
         GOTO 999
      END IF
      IF(NDIMS2.NE.2) THEN
        CALL PAR_WRUSER('Incorrect number of data dimensions', STATUS)
        GOTO 999
      END IF
      NPIX  = DIMS2(1)
      NSPEC = DIMS2(2)
      CALL DTA_RDVARD('DATA.HEAD.ARC',2,ARC,STATUS)
      IF(STATUS.NE.0) THEN
        CALL PAR_WRUSER('Could not read ARC coefficients', STATUS)
        GOTO 999
      END IF
*
* Get name of file for modified error bars 
*
      NBLOCK = MAX(3, NPIX*NSPEC/128)
      CALL PAR_RDCHAR('OUTPUT',' ',OUTPUT)
      CALL DTA_ASFNAM('OUTPUT',OUTPUT(:ICH_LEN(OUTPUT))//'.DST',
     &           'NEW',NBLOCK,'Data',STATUS)
      IF (STATUS.NE.0) THEN
         CALL FIG_DTAERR(STATUS,'Unable to open data file')
         GOTO 999
      END IF
      OOPEN = .TRUE.
*
* Copy whole data file into this one 
*
      CALL DTA_CYVAR('DATA','OUTPUT',STATUS)
*
* Get parameters specifying alteration
*
      CALL PAR_RDVAL('XCEN',-1.E10,1.E10,0.,' ', XCEN)
      CALL PAR_RDVAL('YCEN',-1.E10,1.E10,0.,' ', YCEN)
      CALL PAR_RDVAL('RADIUS',0.,1.E10,100.,' ', RADIUS)
      CALL PAR_RDVAL('SHIFT',-1.E10,1.E10,0.,' ', SHIFT)
      CALL PAR_RDVAL('FACTOR',-1.E10,1.E10, 1.,' ', FACTOR)
*
* Write information into header. Skip previous
* similar comments
*
      IMCOMP = 'OUTPUT.HEAD.SERR'
      I = 0
10    I = I + 1
      WRITE(IMCOMP(17:17),'(I1)') I
      CALL DTA_TYVAR(IMCOMP(:17), TYPE, STATUS)
      IF(STATUS.EQ.0) GOTO 10
*
      CALL DTA_CRVAR(IMCOMP(:17),'STRUCT',STATUS)
      IF(STATUS.NE.0) THEN
        CALL PAR_WRUSER('Error creating structure',STATUS)
        GOTO 999
      END IF
      IMCOMP(18:18) = '.'
      IMCOMP(19:22) = 'XCEN'
      CALL DTA_CRVAR(IMCOMP(:22),'FLOAT',STATUS)
      IF(STATUS.NE.0) THEN
        CALL PAR_WRUSER('Error creating '//IMCOMP(:22),STATUS)
        GOTO 999
      END IF
      CALL DTA_WRVARF(IMCOMP(:22),1,XCEN,STATUS)
      IF(STATUS.NE.0) THEN
        CALL PAR_WRUSER('Error setting XCEN',STATUS)
        GOTO 999
      END IF
*
      IMCOMP(19:22) = 'YCEN'
      CALL DTA_CRVAR(IMCOMP(:22),'FLOAT',STATUS)
      IF(STATUS.NE.0) THEN
        CALL PAR_WRUSER('Error creating '//IMCOMP(:22),STATUS)
        GOTO 999
      END IF
      CALL DTA_WRVARF(IMCOMP(:22),1,YCEN,STATUS)
      IF(STATUS.NE.0) THEN
        CALL PAR_WRUSER('Error setting YCEN',STATUS)
        GOTO 999
      END IF
*
      IMCOMP(19:24) = 'RADIUS'
      CALL DTA_CRVAR(IMCOMP(:24),'FLOAT',STATUS)
      IF(STATUS.NE.0) THEN
        CALL PAR_WRUSER('Error creating '//IMCOMP(:24),STATUS)
        GOTO 999
      END IF
      CALL DTA_WRVARF(IMCOMP(:24),1,RADIUS,STATUS)
      IF(STATUS.NE.0) THEN
        CALL PAR_WRUSER('Error setting RADIUS',STATUS)
        GOTO 999
      END IF
*
      IMCOMP(19:23) = 'SHIFT'
      CALL DTA_CRVAR(IMCOMP(:23),'FLOAT',STATUS)
      IF(STATUS.NE.0) THEN
        CALL PAR_WRUSER('Error creating '//IMCOMP(:23),STATUS)
        GOTO 999
      END IF
      CALL DTA_WRVARF(IMCOMP(:23),1,SHIFT,STATUS)
      IF(STATUS.NE.0) THEN
        CALL PAR_WRUSER('Error setting SHIFT',STATUS)
        GOTO 999
      END IF
*
      IMCOMP(19:24) = 'FACTOR'
      CALL DTA_CRVAR(IMCOMP(:24),'FLOAT',STATUS)
      IF(STATUS.NE.0) THEN
        CALL PAR_WRUSER('Error creating '//IMCOMP(:24),STATUS)
        GOTO 999
      END IF
      CALL DTA_WRVARF(IMCOMP(:24),1,FACTOR,STATUS)
      IF(STATUS.NE.0) THEN
        CALL PAR_WRUSER('Error setting FACTOR',STATUS)
        GOTO 999
      END IF
*
* Map errors and phases
*
      NELM = NPIX*NSPEC
      CALL DTA_MUVARF('OUTPUT.Z.ERRORS',NELM,IPIN1,STATUS)
      IF(STATUS.NE.0) THEN
        CALL PAR_WRUSER('Unable to map errors', STATUS)
        GOTO 999
      END IF
      OMAP1 = .TRUE.
      CALL DTA_MRVARF('OUTPUT.HEAD.PHASES',NSPEC,IPIN2,STATUS)
      IF(STATUS.NE.0) THEN
        CALL PAR_WRUSER('Unable to map phases', STATUS)
        GOTO 999
      END IF
      OMAP2 = .TRUE.
*
* Compute data
*
      SHIFT = SHIFT + GAMMA
      CALL ERRMOD(%VAL(CNF_PVAL(IPIN1)), %VAL(CNF_PVAL(IPIN2)), 
     :            NPIX, NSPEC, ARC,
     &OFFSET, WAVE, NIMAGE, XCEN, YCEN, RADIUS, SHIFT, FACTOR)
*
* Tidy up
*
999   CONTINUE
      IF(FAULT) CALL FIG_SETERR
      IF (OMAP1) THEN
         CALL DTA_FRVAR('OUTPUT.Z.ERRORS',STATUS)
         IF (STATUS.NE.0) THEN
           CALL FIG_DTAERR(STATUS,'Error unmapping OUTPUT')
         END IF
      END IF
      IF (OMAP2) THEN
         CALL DTA_FRVAR('OUTPUT.HEAD.PHASES',STATUS)
         IF (STATUS.NE.0) THEN
           CALL FIG_DTAERR(STATUS,'Error unmapping phases')
         END IF
      END IF
      IF (OOPEN) THEN
        CALL DTA_FCLOSE('OUTPUT',STATUS)
        IF (STATUS.NE.0) THEN
          CALL FIG_DTAERR(STATUS,'Error closing output file')
        END IF
      END IF
      IF (IOPEN) THEN
         CALL DTA_FCLOSE('IMAGE',STATUS)
         IF (STATUS.NE.0) THEN
           CALL FIG_DTAERR(STATUS,'Error closing image file')
         END IF
      END IF
      IF (DOPEN) THEN
         CALL DTA_FCLOSE('DATA',STATUS)
         IF (STATUS.NE.0) THEN
           CALL FIG_DTAERR(STATUS,'Error closing input file')
         END IF
      END IF
      RETURN
      END	
