      SUBROUTINE RADISC(DISC,NX,NY,XCEN,YCEN,VPIX,FWHM)
*
* RADISC starts from XCEN, YCEN and finds the position of the
* maximum for a series of angles covering the full 360 degrees.
* It then plots these as a graph of speed versus angle.
*
      REAL DISC(NX, NY), XCEN, YCEN, VPIX, FWHM
      PARAMETER (NPLOT = 361)
      REAL PLOTX(NPLOT), PLOTY(NPLOT)
*
      PARAMETER (NSAMP = 500)
      REAL WORK(NSAMP)
*
      DMAX = 0.
      DO I = 1, NPLOT
        AZIM = 360.*REAL(I-1)/REAL(NPLOT-1)
        PLOTX(I) = AZIM
        ANGLE = 90. - AZIM
        CX = COSD(ANGLE)
        SX = SIND(ANGLE)
*
* Compute the distance to the edge of array 
*
        IF(CX.GE.0. .AND. SX.GE.0.) THEN
          IF((REAL(NY)-YCEN)*CX .GT. (REAL(NX)-XCEN)*SX) THEN
            DIST = (REAL(NX)-XCEN)/CX
          ELSE
            DIST = (REAL(NY)-YCEN)/SX
          END IF
        ELSE IF(CX.GE.0. .AND. SX.LT.0.) THEN
          IF((1.-YCEN)*CX .LT. (REAL(NX)-XCEN)*SX) THEN
            DIST = (REAL(NX)-XCEN)/CX
          ELSE
            DIST = (1.-YCEN)/SX
          END IF
        ELSE IF(CX.LT.0. .AND. SX.LT.0.) THEN
          IF((1.-YCEN)*CX .GT. (1.-XCEN)*SX) THEN
            DIST = (1.-XCEN)/CX
          ELSE
            DIST = (1.-YCEN)/SX
          END IF
        ELSE IF(CX.LT.0. .AND. SX.GE.0.) THEN
          IF((REAL(NY)-YCEN)*CX .LT. (1.-XCEN)*SX) THEN
            DIST = (1.-XCEN)/CX
          ELSE
            DIST = (REAL(NY)-YCEN)/SX
          END IF
        END IF
*
        NRAD = MAX(2,NINT(2.*DIST))
        IF(NRAD.GT.NSAMP) THEN
          NRAD = NSAMP
          CALL PAR_WRUSER('Slice undersampled', IFAIL)
        END IF
*
* Sample along slice
*
        DIST = 0.995*DIST
        GX = DIST*CX/REAL(NRAD-1)
        GY = DIST*SX/REAL(NRAD-1)
        WMAX = -1.E35
        DO J = 1, NRAD
          X = XCEN + GX*REAL(J-1)
          Y = YCEN + GY*REAL(J-1)
          IX1 = INT(X)
          IY1 = INT(Y)
          IX2 = IX1 + 1
          IY2 = IY1 + 1
          X  = X - REAL(IX1)
          Y  = Y - REAL(IY1)
          Z1 = DISC(IX1,IY1)
          Z2 = DISC(IX2,IY1)
          Z4 = DISC(IX1,IY2)
          Z3 = DISC(IX2,IY2)
          WORK(J) = BILIN(X,Y,Z1,Z2,Z3,Z4)
          IF(WORK(J).GT.WMAX) THEN
            JMAX = J
            WMAX = WORK(J)
          END IF
        END DO
*
* Parabolic interpolation or MEDIAN
*
        IF(JMAX.EQ.1 .OR. JMAX.EQ.NRAD) THEN
          PLOTY(I) = VPIX*DIST*REAL(JMAX-1)/REAL(NRAD-1)
        ELSE
          IF(FWHM.LT.2.) THEN
            PLOTY(I) = VPIX*DIST/REAL(NRAD-1)*(REAL(JMAX-1) - 
     &      (WORK(JMAX+1)-WORK(JMAX-1))/2.
     &      /(WORK(JMAX+1)+WORK(JMAX-1)-2.*WORK(JMAX)))
          ELSE
            CALL MEDIAN(WORK,NRAD,JMAX,FWHM,RBIN,SIGBIN,1)
            PLOTY(I) = VPIX*DIST/REAL(NRAD-1)*(RBIN-1.)
          END IF
        END IF
        DMAX = MAX(DMAX, PLOTY(I))
      END DO
*
      X1 = -10.
      X2 = 730
      Y1 = 0.
      Y2 = 1.1*DMAX
      CALL SETLIMS(X1,X2,Y1,Y2)
      CALL PGFSTAR(1,1)
      CALL PGENV(X1,X2,Y1,Y2,0,0)
      CALL PGLABEL('Azimuth (degrees)','Velocity (km/s)', ' ')
      CALL PGLINE(NPLOT, PLOTX, PLOTY)
      DO I = 1, NPLOT
        PLOTX(I) = PLOTX(I) + 360.
      END DO
      CALL PGLINE(NPLOT, PLOTX, PLOTY)
      CALL PGEND
999   RETURN
      END
