      SUBROUTINE PROFMED( DISC, NX, NY, X0, Y0,
     &     RMIN, RMAX, PROF, NRAD)
C
C Evaluates radial profile of a cartesian image
C by taking median of values sampled on concentric annular rings.
C
C Input:
C      DISC(NX,NY)   = R4 image data
C      NX,NY         = I4 image dimensions of cartesian image
C      X0,Y0       = R4 coordinates of origin
C      NRAD          = I4 max number of radial samples
C Output:
C      NRAD        = I4 actual number of radial samples
C      RMIN        = R4 minimum radius sampled
C      RMAX        = R4 maximum radius sampled
C      PROF(NRAD)  = R4 radial profile data
C
C March 1988 Keith Horne @ STScI. Modified by T.R.Marsh from original
C so that it assumes X,Y coordinates which run from 1 to NX, 1 to NY
C in each direction.
C
C Dec 1988, changed interpolation from nearest neighbour to bilinear
C TRM, @STSCI
C
      IMPLICIT NONE
      INTEGER NX, NY, NRAD, MAXRAD, NVALS
      REAL DISC(NX,NY), PROF(NRAD), MEDVAL, BILIN
      REAL TWOPI, DX1, DXN, DY1, DYN, Z1, Z2, Z3, Z4
      REAL X, Y, RADIAN, X0, Y0, D2X1, D2XN, D2Y1, D2YN
      REAL DMAX, DMIN, RMIN, RMAX, PART, RADIUS
      INTEGER MAXAZ, IX1, IX2, IY1, IY2, NAZ, IAZ, IRAD
      PARAMETER (MAXAZ=6000)
      REAL RINGVALS(MAXAZ)
C
      TWOPI = 8.*ATAN(1.)
C
C trap bad inputs
C
      IF(NX.LT.2 .OR. NY.LT.2 .OR. NRAD.LT.2) THEN
         WRITE(*,'(A,I5,1X,I5,1X,I5)')
     &        ' Invalid dimensions ',NX, NY, NRAD
         STOP
      END IF
      MAXRAD = NRAD
C
C     determine min and max pixel distance from origin to four image corners
C
      DX1 = 1. - X0       
      DXN = REAL(NX) - X0 
      DY1 = 1. - Y0 
      DYN = REAL(NY) - Y0 
      D2X1 = DX1*DX1
      D2XN = DXN*DXN
      D2Y1 = DY1*DY1
      D2YN = DYN*DYN
      DMAX = SQRT( MAX( D2X1, D2XN ) + MAX( D2Y1, D2YN ) )
      IF( DX1.GT.0. .OR. DXN.LT.0. .OR. DY1.GT.0. .OR. DYN.LT.0. ) THEN
         DMIN = SQRT( MIN( D2X1, D2XN ) + MIN( D2Y1, D2YN ) )
      ELSE
         DMIN = 0.
      END IF
C     
C     these determine the radius range sampled by the image
C
      RMIN = DMIN
      RMAX = DMAX
C
C     set number of radial samples at 2 per pixel
C
      NRAD = 1 + INT(2.*( DMAX - DMIN ))
      NRAD = MAX( 2, NRAD )
      IF(NRAD.GT.MAXRAD) NRAD = MAXRAD
C
C     Loop over required range of radial distances
C     
      DO IRAD = 1, NRAD
         PART = REAL(IRAD-1)/ REAL(NRAD-1)
         RADIUS = RMIN * (1.-PART) + RMAX * PART
C     
C     take data samples around a ring
C
         NAZ = MAX( 8, NINT(TWOPI*IRAD) )
 100     NVALS = 0
         DO IAZ = 1, NAZ
            PART = REAL(IAZ)/ REAL(NAZ-1)
            RADIAN = TWOPI * PART
            X = X0 + RADIUS * COS(RADIAN)
            Y = Y0 + RADIUS * SIN(RADIAN)
            IX1 = INT(X)
            IY1 = INT(Y)
            IX2 = IX1 + 1
            IY2 = IY1 + 1
            IF(IX1.LE.NX .AND. IX2.GE.1 .AND. IY1.LE.NY 
     &           .AND. IY2.GE.1) THEN
               IF( NVALS.LT.MAXAZ ) THEN
                  X  = X - REAL(IX1)
                  Y  = Y - REAL(IY1)
                  IX1 = MAX( 1, IX1)
                  IY1 = MAX( 1, IY1)
                  IX2 = MIN(NX, IX2)
                  IY2 = MIN(NY, IY2)
                  NVALS = NVALS + 1
                  Z1 = DISC(IX1,IY1)
                  Z2 = DISC(IX2,IY1)
                  Z4 = DISC(IX1,IY2)
                  Z3 = DISC(IX2,IY2)
                  RINGVALS(NVALS) = BILIN(X,Y,Z1,Z2,Z3,Z4)
               ELSE
                  NAZ = MAX( 8, NAZ/2 )
                  GOTO 100
               END IF
            END IF
         END DO
C     
C     compute median value of the samples
C     
         PROF(IRAD) = MEDVAL( RINGVALS, NVALS )
      END DO
      RETURN
      END
