      SUBROUTINE PROFADD( DISC, NX, NY, X0, Y0,
     &     RMIN, RMAX, PROF, NRAD)
*
*     Sets image to have radial profile given by PROF
*     by linearly interpolating in the radial profile.
*     Adapted from KDH routine of same name
*
*     Input:
*
*       DISC(NX,NY)   = R4 image data
*       NX,NY         = I4 image dimensions of cartesian image
*       X0,Y0         = R4 coordinates of origin
*       RMIN          = R4 minimum radius sampled
*       RMAX          = R4 maximum radius sampled
*       NRAD          = I4 number of radial samples
*       PROF(NRAD)    = R4 radial profile data
*
*     Output:
*
*       DISC(NX,NY)   = R4 image data, symmetric on X0,Y0 with radial
*                       profile PROF
*
      IMPLICIT NONE
      INTEGER NX, NY, NRAD, IY, IX, IRAD, IM, IP
      REAL DISC(NX,NY), PROF(NRAD), X0, Y0, RMIN, RMAX
      REAL DYSQ, DXSQ, RADIUS, PART, RADPIX
C
C     trap bad inputs
c
      IF( NX.LT.1 .OR. NY.LT.1 .OR. NRAD.LT.1 ) THEN
         WRITE(*,'(A,I5,1X,I5,1X,I5)')
     &        ' Invalid dimensions ',NX, NY, NRAD
         STOP
      END IF
      DO IY = 1, NY
         DYSQ = (REAL(IY)-Y0)**2
         DO IX = 1, NX
            DXSQ = (REAL(IX)-X0)**2
            RADIUS = SQRT( DXSQ + DYSQ )
            PART = (RADIUS - RMIN) / (RMAX - RMIN)
            RADPIX = 1. - PART + REAL(NRAD)*PART
            IRAD = INT(RADPIX)
            IM = MAX( 1, MIN( NRAD, IRAD ) )
            IP = MAX( 1, MIN( NRAD, IRAD+1 ) )
            PART = RADPIX - IM
            DISC(IX,IY) = PROF(IM)*(1.-PART) + PROF(IP)*PART
         END DO
      END DO
      RETURN
      END



