      SUBROUTINE PHCOMP(HJD, NTIME, PHASE, HJD0, PERIOD, STATUS)
C
C     Computes phases from HJDs and ephemeris.
C     
      IMPLICIT NONE
      INCLUDE 'SAE_PAR'
      INTEGER NTIME, I, STATUS
      DOUBLE PRECISION HJD(NTIME), HJD0, PERIOD
      DOUBLE PRECISION PHASE(NTIME)     
      IF(STATUS.NE.SAI__OK) RETURN
      DO I = 1, NTIME
         PHASE(I) = (HJD(I)-HJD0)/PERIOD
      END DO
      RETURN
      END
      
      SUBROUTINE PWCOMP(DWELL, NTIME, PWIDTH, PERIOD, STATUS)
C
C     Computes phase widths of exposures from exposure times
C
      IMPLICIT NONE
      INCLUDE 'SAE_PAR'
      INTEGER NTIME, I, STATUS
      DOUBLE PRECISION PERIOD
      REAL PWIDTH(NTIME), DWELL(NTIME)
      IF(STATUS.NE.SAI__OK) RETURN
      DO I = 1, NTIME
         PWIDTH(I) = REAL(DWELL(I)/PERIOD/24./3600.)
      END DO
      RETURN
      END
