      SUBROUTINE OP(DISC,DAT,PHASES,PWIDTH,STATUS)
C     
C     Dec 1988 by T.R. Marsh @STScI
C     Calculates the emission line profiles DAT(NPIX,NSPEC), from the
C     disc surface emission DISC(NSIDE,NSIDE,NIMAGE) in velocity space.
C
C     Method:
C
C     Each pixel is projected onto a finely sampled version of the
C     data array with NDIV pixels per data pixel. The fine array is
C     then blurred and binned into the output array. This method is
C     much faster than doing the blurring on each disc pixel.
C

      IMPLICIT NONE
      INCLUDE 'SAE_PAR'
      INCLUDE 'doppler.inc'
      REAL DISC(NSIDE,NSIDE,NIMAGE), DAT(NPIX,NSPEC), PWIDTH(NSPEC)
      DOUBLE PRECISION PHASES(NSPEC), PHASE, TWOPI
      INTEGER NFPIX, N, STATUS, K, J, NADD, L, I, M
      REAL VZERO, WZERO, VDPIX
      REAL AREA, VFPIX, VFZER, COSP, SINP, PWGT, VREST
      REAL SCARE, VF1, VF2, VF3, VY, VQ1, VQ2, VLIGHT, CGS
      DOUBLE PRECISION EFAC, SUM
C     
      IF(STATUS.NE.SAI__OK) RETURN
      VLIGHT = CGS('C')/1.E5
      TWOPI = 8.D0*ATAN(1.D0)
      DO J = 1, NSPEC
         DO I = 1, NPIX
            DAT(I,J) = 0.
         END DO
      END DO
      VDPIX = REAL(VLIGHT*ARC(2)/DBLE(NPIX))
C
C     Compute smoothing array once. This is used to blurr
C     the fine array.
C     
      IF(OPFIR) THEN
         OPFIR   = .FALSE.
         NSMOOTH = INT(REAL(NDIV)*DEVMAX*FWHM/2.3548/VDPIX)+1
         IF(NSMOOTH.GT.MAXSM) THEN
            STATUS = SAI__ERROR
            CALL ERR_REP(' ','Smoothing buffer too small.',
     &           STATUS)
            RETURN
         END IF
         SUM = 0.D0
         EFAC = 4.D0*LOG(2.D0)/(DBLE(NDIV)*DBLE(FWHM/VDPIX))**2
         DO I = -NSMOOTH, NSMOOTH
            SMOOTH(I) = EXP(-EFAC*DBLE(I)**2)
            SUM = SUM + SMOOTH(I)
         END DO
         DO I = -NSMOOTH, NSMOOTH
            SMOOTH(I) = SMOOTH(I)/SUM
         END DO
      END IF
C     
C     Avoid repeated evaluations inside loop
C
C     Meanings of variables:
C
C     VDPIX   -- km/s/data pixel
C     VZERO   -- offset velocity for image
C     WZERO   -- ln(central wavelength of data)
C     AREA    -- pixel area (km/s)**2 times wavelength/(km/s/data pix)
C     VFPIX   -- km/s/fine array pixel (NDIV per data pixel)
C     NFPIX   -- number of fine array pixels
C     VFZER   -- offset velocity for fine array
C
      VZERO = -VPIX*REAL(NSIDE+1)/2.
      WZERO = REAL(ARC(1)+ARC(2)*DBLE(NPIX+1)/2/DBLE(NPIX))
      AREA  = VPIX*VPIX*1.E-7*EXP(WZERO)/VDPIX
      VFPIX = VDPIX/REAL(NDIV)
      NFPIX = NDIV*NPIX
      IF(NFPIX.GT.MAXFBF) THEN
         STATUS = SAI__ERROR
         CALL ERR_REP(' ','FAST buffer too small',STATUS)
         RETURN
      END IF
      VFZER = - VFPIX*REAL(NFPIX+1)/2.
C     
C     Loop through each spectrum
C  
      DO N = 1, NSPEC
C     
C     Initialise projection buffer
C     
         DO I = 1, NFPIX
            FBF(I) = 0.D0
         END DO
C     
C     Loop through each sub-division of phase bin
C     
         DO M = 1, MAX(1,NSUB)
            PHASE = PHASES(N) + DBLE(OFFSET) + 
     &           DBLE(PWIDTH(N))*(DBLE(M)-DBLE(1+NSUB)/2.)/
     &           DBLE(MAX(1,NSUB-1))                
            COSP  = SNGL(COS(TWOPI*PHASE))
            SINP  = SNGL(SIN(TWOPI*PHASE))
C     
C     Trapezoidal weights for projections to average over
C     phase bin.
C     
            IF(NSUB.LE.1) THEN
               PWGT = AREA
            ELSE IF(M.EQ.1 .OR. M.EQ.NSUB) THEN
               PWGT = 0.5*AREA/REAL(NSUB-1)
            ELSE
               PWGT = AREA/REAL(NSUB-1)
            END IF
C     
C     Loop through each line. Compute the velocity offset
C     to add to the radial velocities computed for each image.
C     
            DO K = 1, NWAVE
               VREST = VLIGHT*(LOG(WAVE(K))-WZERO)+GAMMA
               SCARE = PWGT*SCALE(K)
               VF1   = VZERO/VFPIX
               VF2   = VPIX/VFPIX
               VF3   = (VREST-VFZER)/VFPIX
               DO I = 1, NFPIX
                  DBF(I) = 0.D0
               END DO
               DO J = 1, NSIDE
                  VY   = VF1 + VF2*REAL(J)
                  VQ1  = VF3 + VY*SINP - VF1*COSP
                  VQ2  = VF2*COSP
C
C     Innermost loop now
C
                  DO I = 1, NSIDE
                     NADD = NINT(VQ1-VQ2*REAL(I))
C         
C     Multiply disc element by (scaled) area in (km/s)**2, the inverse
C     frequency factor and the scale factor for the line in question.
C     
                     IF(NADD.GE.1 .AND. NADD.LE.NFPIX)
     &                    DBF(NADD) = DBF(NADD) + DISC(I,J,NWHICH(K))
                  END DO  
               END DO
               DO I = 1, NFPIX
                  FBF(I) = FBF(I) + SCARE*DBF(I)
               END DO
            END DO
         END DO
C     
C     Now blurr and bin
C     
         DO I = 1, NPIX
            SUM = 0.D0
C     
C     Add in contribution from all the pixels in the fine array
C     that will bin into pixel I
C     
            DO J = NDIV*(I-1)+1, NDIV*I
C
C     blurr the fine array pixels out before binning
C     
               DO K = -NSMOOTH, NSMOOTH
                  L = J + K
                  IF(L.GE.1 .AND. L.LE.NFPIX) 
     &                 SUM = SUM + SMOOTH(K)*FBF(L)
               END DO
            END DO
            DAT(I,N) = REAL(SUM)
         END DO
      END DO
      RETURN
      END

      SUBROUTINE TR(DAT,DISC,PHASES,PWIDTH,STATUS)
C
C     Performs transpose of OP. See comments in OP for
C     details of the method used.
C     
      IMPLICIT NONE
      INCLUDE 'SAE_PAR'
      INCLUDE 'doppler.inc'
      REAL DISC(NSIDE,NSIDE,NIMAGE),DAT(NPIX,NSPEC), PWIDTH(NSPEC)
      DOUBLE PRECISION PHASES(*), PHASE, TWOPI
      INTEGER NFPIX, N, STATUS, I, J, K, L, M, NADD
      REAL VZERO, WZERO, VDPIX
      REAL AREA, VFPIX, VFZER, COSP, SINP, PWGT, VREST
      REAL SCARE, VF1, VF2, VF3, VY, VQ1, VQ2, VLIGHT, CGS 
      DOUBLE PRECISION  ADD, SUM, EFAC
C     
      IF(STATUS.NE.SAI__OK) RETURN
      VLIGHT = CGS('C')/1.E5
      TWOPI  = 8.D0*ATAN(1.D0)
C     
C     Zero image array
C     
      DO K = 1, NIMAGE
         DO J = 1, NSIDE
            DO I = 1, NSIDE
               DISC(I,J,K) = 0.
            END DO
         END DO
      END DO
C
      VDPIX = REAL(VLIGHT*ARC(2)/DBLE(NPIX))
      IF(OPFIR) THEN
         OPFIR = .FALSE.
         NSMOOTH = INT(REAL(NDIV)*DEVMAX*FWHM/2.3548/VDPIX)+1
         IF(NSMOOTH.GT.MAXSM) THEN
            STATUS = SAI__ERROR
            CALL ERR_REP(' ','Smoothing buffer too small.',
     &           STATUS)
            RETURN
         END IF
         SUM = 0.D0
         EFAC = 4.D0*LOG(2.D0)/(DBLE(NDIV)*DBLE(FWHM/VDPIX))**2
         DO I = -NSMOOTH, NSMOOTH
            SMOOTH(I) = EXP(-EFAC*DBLE(I)**2)
            SUM = SUM + SMOOTH(I)
         END DO
         DO I = -NSMOOTH, NSMOOTH
            SMOOTH(I) = SMOOTH(I)/SUM
         END DO
      END IF
C     
C     Avoid repeated evaluations inside loop
C
      VZERO = - VPIX*REAL(NSIDE+1)/2.
      WZERO = REAL(ARC(1)+ARC(2)*DBLE(NPIX+1)/2/DBLE(NPIX))
      AREA  = VPIX*VPIX*1.E-7*EXP(WZERO)/VDPIX
      VFPIX = VDPIX/REAL(NDIV)
      NFPIX = NDIV*NPIX
      IF(NFPIX.GT.MAXFBF) THEN
         STATUS = SAI__ERROR
         CALL ERR_REP(' ','FAST buffer too small',STATUS)
         RETURN
      END IF
      VFZER = - VFPIX*REAL(NFPIX+1)/2.
C     
C     Loop through each spectrum
C     
      DO N = 1, NSPEC
C     
C     Transpose of blurr/bin section
C     
         DO I = 1, NFPIX
            FBF(I) = 0.D0
         END DO
         DO I = 1, NPIX
            ADD = DAT(I,N)
            DO J = NDIV*(I-1)+1, NDIV*I
               DO K = -NSMOOTH, NSMOOTH
                  L = J + K
                  IF(L.GE.1 .AND. L.LE.NFPIX) THEN
                     FBF(L) = FBF(L) + SMOOTH(K)*ADD
                  END IF
               END DO
            END DO
         END DO
C     
C     Now transpose of projection. Loop through each 
C     sub-division of phase bin
C     
         DO M = 1, MAX(1,NSUB)
            PHASE = PHASES(N) + DBLE(OFFSET) + 
     &           DBLE(PWIDTH(N))*(DBLE(M)-DBLE(1+NSUB)/2.)/
     &           DBLE(MAX(1,NSUB-1))                
            COSP  = SNGL(COS(TWOPI*PHASE))
            SINP  = SNGL(SIN(TWOPI*PHASE))
C     
C     Trapezoidal weights for projections to average over
C     phase bin.
C     
            IF(NSUB.LE.1) THEN
               PWGT = AREA
            ELSE IF(M.EQ.1 .OR. M.EQ.NSUB) THEN
               PWGT = 0.5*AREA/REAL(NSUB-1)
            ELSE
               PWGT = AREA/REAL(NSUB-1)
            END IF
            DO K = 1, NWAVE
               VREST = VLIGHT*(LOG(WAVE(K))-WZERO)+GAMMA
               SCARE = PWGT*SCALE(K)
               DO I = 1, NFPIX
                  DBF(I) = SCARE*FBF(I)
               END DO
               VF1 = VZERO/VFPIX
               VF2 = VPIX/VFPIX
               VF3 = (VREST-VFZER)/VFPIX
               DO J = 1, NSIDE
                  VY   = VF1 + VF2*REAL(J)
                  VQ1  = VF3 + VY*SINP - VF1*COSP
                  VQ2  = VF2*COSP
                  DO I = 1, NSIDE
                     NADD = NINT(VQ1 - VQ2*REAL(I))
                     IF(NADD.GE.1 .AND. NADD.LE.NFPIX)
     &                    DISC(I,J,NWHICH(K)) = REAL(
     &                    DISC(I,J,NWHICH(K)) + DBF(NADD))
                  END DO
               END DO
            END DO
         END DO
      END DO
      RETURN
      END
      

