      SUBROUTINE MAXPOT
*
* M A X P O T
*
* Written by T.R. Marsh, plots position of maximum found
* along a series of azimuths starting from the same point
*
*
* FIGARO variables:
*
* IMAGE     -- The image file to load
*
* NIMAGE    -- The particular image to treat
*
* XCEN      -- X coordinate of centre of symmetry
*
* YCEN      -- Y coordinate of centre of symmetry
*
* FWHM      -- FWHM of gaussian for median
*
      IMPLICIT NONE
*
* Functions
*
      INTEGER ICH_LEN, INT
      REAL LOG10
*
* Local variables
*
      INTEGER STATUS
      INTEGER DIMS1(3)
      CHARACTER*32 IMAGE, MAPPED
      CHARACTER*32 CMPNAM, IMCOMP, SPCOMP, TYPE*16
      LOGICAL IOPEN, OOPEN, OMAP
      LOGICAL FAULT, IMAP, VPLOT, XLOG, YLOG, ERASE
      INTEGER NDIMS1, NDIMS2, NELM, LFILE, NBLOCK
      INTEGER I, IFAIL, J, IEFIND, ICFIND
      INTEGER NX, NY, NIMAGE, NFIG
      REAL XCEN, YCEN, KW, KR, VPIX, RIMAGE, FWHM
      INTEGER IPIN1, IPIN2
*
* Initialise logical flags
*
      FAULT = .TRUE.
      IMAP   = .FALSE.
      IOPEN  = .FALSE.
*
* Get image region input file 
*
      CALL PAR_RDCHAR('IMAGE',' ',IMAGE)
      CALL DTA_ASFNAM('IMAGE',IMAGE(:ICH_LEN(IMAGE))//'.DST',
     &           'OLD',0,' ',STATUS)
      IF (STATUS.NE.0) THEN
         CALL FIG_DTAERR(STATUS,'Unable to open input file')
         GOTO 999
      END IF
      IOPEN = .TRUE.
*
*     Get size of data array
*
      CALL DTA_SZVAR('IMAGE.Z.DATA',10,NDIMS1,DIMS1,STATUS)
      IF (STATUS.NE.0) THEN
         CALL FIG_DTAERR(STATUS,'Unable to get dimensions of frame')
         GOTO 999
      END IF
      IF(NDIMS1.NE.2 .AND. NDIMS1.NE.3) THEN
        CALL PAR_WRUSER('Invalid number of dimensions',STATUS)
        GOTO 999
      END IF
      NX = DIMS1(1)
      NY = DIMS1(2)
      NIMAGE = 1
      IF(NDIMS1.EQ.3) THEN
        IF(DIMS1(3).GT.1) THEN
          CALL PAR_RDVAL('NIMAGE',1.,REAL(DIMS1(3)),1.,' ',RIMAGE)
          NIMAGE = NINT(RIMAGE)
        END IF
      ELSE
        NIMAGE = 1
      END IF
*
* Read pixel size
*
      CALL DTA_RDVARF('IMAGE.HEAD.VPIX',1,VPIX,STATUS)
      IF(STATUS.NE.0) THEN
        CALL PAR_WRUSER('Unable to read pixel size', STATUS)
        CALL PAR_WRUSER('Will set equal to 1', STATUS)
        VPIX = 1.
      END IF
*
* Get centre of symmetry. Centre of image = 0,0
*
      CALL PAR_RDVAL('XCEN',-1.E10,1.E10,0.,' ',XCEN)
      CALL PAR_RDVAL('YCEN',-1.E10,1.E10,0.,' ',YCEN)
*
* Convert coordinates to those used by subroutine
*
      XCEN = XCEN/VPIX + REAL(NX+1)/2.
      YCEN = YCEN/VPIX + REAL(NY+1)/2.
*
* Get FWHM of gaussian for peak measurement with MEDIAN
*
      CALL PAR_RDVAL('FWHM',0.,1000.,4.,' ',FWHM)
*
* Map input data
*
      NELM = NX*NY
      IF(NIMAGE.GT.1) THEN
        MAPPED = 'IMAGE.Z.DATA[1,1,'
        NFIG = INT(LOG10(REAL(NIMAGE))) + 1
        MAPPED(18+NFIG:18+NFIG) = ']'
        WRITE(MAPPED(18:17+NFIG),'(I<NFIG>)') NIMAGE
      ELSE
        MAPPED = 'IMAGE.Z.DATA'
      END IF
      CALL DTA_MRVARF(MAPPED,NELM,IPIN1,STATUS)
      IF(STATUS.NE.0) THEN
        CALL PAR_WRUSER('Unable to map input file', STATUS)
        GOTO 999
      END IF
      IMAP = .TRUE.
*
* Compute radius of image
*
      CALL RADISC(%VAL(CNF_PVAL(IPIN1)), NX, NY, XCEN, YCEN, VPIX, FWHM)
      FAULT = .FALSE.
*
*     Tidy up
*
999   CONTINUE
      IF(FAULT) CALL FIG_SETERR
      IF (IMAP) THEN
         CALL DTA_FRVAR(MAPPED,STATUS)
         IF (STATUS.NE.0) THEN
           CALL FIG_DTAERR(STATUS,'Error unmapping input data')
         END IF
      END IF
      IF (IOPEN) THEN
         CALL DTA_FCLOSE('IMAGE',STATUS)
         IF (STATUS.NE.0) THEN
           CALL FIG_DTAERR(STATUS,'Error closing input file')
         END IF
      END IF
      RETURN
      END	
