*MAKCIRC
*
* MAKCIRC -- zeroes all pixels outside the largest circle that fits within image*
*
* Sometimes the corners of the square images lead to distracting features that
* slew back and forth across the fitted trails. If pixels are set to zero, I
* believe that they stay at zero. 'makcirc' carries out the zeroing operation.

*
* Parameters
*
* IMAGE     -- The image file to load
*
* OUTPUT    -- Image file to dump (should be different from IMAGE)
*
*MAKCIRC
      SUBROUTINE MAKCIRC(STATUS)
      IMPLICIT NONE
      INCLUDE 'SAE_PAR'
      INCLUDE 'DAT_PAR'
      INCLUDE 'CNF_PAR'
      INTEGER NDIM, DIM(3), LBND(3), UBND(3), ST
     :ATUS
      INTEGER IMAGE, OUTPUT, OPTR, EL, NX, NY, NZ
C
      IF(STATUS.NE.SAI__OK) RETURN
      CALL NDF_BEGIN
C
C     Get name of image file
C
      CALL NDF_ASSOC('IMAGE','UPDATE',IMAGE,STATUS)
      CALL NDF_BOUND(IMAGE, 3, LBND, UBND, NDIM, STATUS)
      IF(STATUS.EQ.SAI__OK .AND. NDIM.EQ.1) THEN
         STATUS = SAI__ERROR
         CALL ERR_REP(' ',
     &        'Images must be 2 or 3D', STATUS)
      END IF
      CALL NDF_DIM(IMAGE,3,DIM,NDIM,STATUS)
      NX = DIM(1)
      NY = DIM(2)
      NZ = DIM(3)
      IF(NX.NE.UBND(1)-LBND(1)+1 .OR.
     &     NY.NE.UBND(2)-LBND(2)+1) THEN
         STATUS = SAI__ERROR
         CALL ERR_REP(' ',
     &        'Cannot take a sub-image with this program', STATUS)
      END IF
C
C     Get output file
C
      CALL NDF_PROP(IMAGE,'AXIS,DATA','OUTPUT',OUTPUT,STATUS)
C
C     Map output data
C
      CALL NDF_MAP(OUTPUT,'Data','_REAL','WRITE',OPTR,EL,STATUS)
C
C     Compute symmetric part of image
C
      CALL CIRCULARISE(%VAL(CNF_PVAL(OPTR)), NX, NY, NZ, STATUS)
C
C     Tidy up
C
      CALL NDF_END(STATUS)
      RETURN
      END

      SUBROUTINE CIRCULARISE(OUTPUT, NX, NY, NZ, STATUS)
C
C     Zeroes all Takes azimuthally symmetric part of NZ images of NX by NY pixels
C
      IMPLICIT NONE
      INCLUDE 'SAE_PAR'
      INTEGER I, J, K, NX, NY, NZ, STATUS
      REAL OUTPUT(NX,NY,NZ), RMAXSQ
      REAL XCEN, YCEN, DIFFSQ
C
      IF(STATUS.NE.SAI__OK) RETURN
      RMAXSQ = MIN((NX-1)/2.+0.1,(NY-1)/2.+0.1)**2
      XCEN = (1+NX)/2.
      YCEN = (1+NY)/2.
      DO K = 1, NZ
         DO J = 1, NY
            DIFFSQ = RMAXSQ-(J-YCEN)**2
            DO I = 1, NX
               IF((I-XCEN)**2 .GT. DIFFSQ) THEN
                  OUTPUT(I,J,K) = 0.
               END IF
            END DO
         END DO
      END DO
      RETURN
      END


