*IMSYMM
*
* IMSYMM -- computes symmetric part of an image.
*
* The result can be subtracted to produce the anti-symmetric residual
* which can be useful for looking for spots. The program works by taking
* the median of along a series of circles centred on a point defined by
* the user. This may for eaxmple be the best guess at where the centre of
* mass of the accreting object lies.
*
* Parameters
*
* IMAGE     -- The image file to load
*
* OUTPUT    -- Image file to dump (should be different from IMAGE)
*
* XCEN      -- X coordinate of centre of symmetry (km/s)
*
* YCEN      -- Y coordinate of centre of symmetry (km/s)
*
*IMSYMM
      SUBROUTINE IMSYMM(STATUS)
      IMPLICIT NONE
      INCLUDE 'SAE_PAR'
      INCLUDE 'DAT_PAR'
      INCLUDE 'CNF_PAR'
      INTEGER NDIM, DIM(3), LBND(3), UBND(3), ST
     :ATUS
      INTEGER IMAGE, OUTPUT, IPTR, OPTR, EL, NX, NY, NZ
      REAL XCEN, YCEN, VPIX
      CHARACTER*(DAT__SZLOC) LOC
C
      IF(STATUS.NE.SAI__OK) RETURN
      CALL NDF_BEGIN
C
C     Get name of image file
C
      CALL NDF_ASSOC('IMAGE','UPDATE',IMAGE,STATUS)
      CALL NDF_BOUND(IMAGE, 3, LBND, UBND, NDIM, STATUS)
      IF(STATUS.EQ.SAI__OK .AND. NDIM.EQ.1) THEN
         STATUS = SAI__ERROR
         CALL ERR_REP(' ',
     &        'Images must be 2 or 3D', STATUS)
      END IF
      CALL NDF_DIM(IMAGE,3,DIM,NDIM,STATUS)
      NX = DIM(1)
      NY = DIM(2)
      NZ = DIM(3)
C
C     Get header items
C
      CALL NDF_XLOC(IMAGE,'DOPPLER_MAP','READ',LOC,STATUS)
      CALL CMP_GET0R(LOC,'VPIX',VPIX,STATUS)
C
C     Get output file
C
      CALL NDF_PROP(IMAGE,'AXIS','OUTPUT',OUTPUT,STATUS)
C
C     Get centre of symmetry. Convert to pixel coords.
C
      CALL PAR_GDR0R('XCEN',0.,-1.E10,1.E10,.FALSE.,XCEN,STATUS)
      CALL PAR_GDR0R('YCEN',0.,-1.E10,1.E10,.FALSE.,YCEN,STATUS)
      IF(STATUS.EQ.SAI__OK) THEN
         XCEN = XCEN/VPIX + REAL(NX+1)/2. - REAL(LBND(1)-1)
         YCEN = YCEN/VPIX + REAL(NY+1)/2. - REAL(LBND(2)-1)
      END IF
C
C     Map input and output data
C
      CALL NDF_MAP(IMAGE, 'Data','_REAL','READ', IPTR,EL,STATUS)
      CALL NDF_MAP(OUTPUT,'Data','_REAL','WRITE',OPTR,EL,STATUS)
C
C     Compute symmetric part of image
C
      CALL SYMMET(%VAL(CNF_PVAL(IPTR)), %VAL(CNF_PVAL(OPTR)),
     :            UBND(1)-LBND(1)+1,
     &     UBND(2)-LBND(2)+1, NZ, XCEN, YCEN, STATUS)
C
C     Tidy up
C
      CALL NDF_END(STATUS)
      RETURN
      END

      SUBROUTINE SYMMET(INPUT, OUTPUT, NX, NY, NZ, XCEN, YCEN, STATUS)
C
C     Takes azimuthally symmetric part of NZ images of NX by NY pixels
C
      IMPLICIT NONE
      INCLUDE 'SAE_PAR'
      INTEGER NX, NY, NZ, K, STATUS
      REAL INPUT(NX,NY,NZ), OUTPUT(NX,NY,NZ), XCEN, YCEN
      REAL RMIN, RMAX
      INTEGER MAXRAD, NRAD
      PARAMETER (MAXRAD = 1000)
      REAL PROFILE(MAXRAD)
C
      IF(STATUS.NE.SAI__OK) RETURN
      DO K = 1, NZ
         NRAD = MAXRAD
         CALL PROFMED( INPUT(1,1,K), NX, NY, XCEN, YCEN,
     &        RMIN, RMAX, PROFILE, NRAD)
         CALL PROFADD( OUTPUT(1,1,K), NX, NY, XCEN, YCEN,
     &        RMIN, RMAX, PROFILE, NRAD)
      END DO
      RETURN
      END


