      SUBROUTINE ERRMOD(ERRORS, PHASES, NPIX, NSPEC, ARC,
     &OFFSET, WAVE, NIMAGE, XCEN, YCEN, RADIUS, SHIFT, FACTOR)
*
* Subroutine for modifying the error array.
*
* REAL ERRORS(NPIX,NSPEC) - Input and output error array
* REAL PHASES(NSPEC)    --- Orbital phases
* INTEGER NPIX, NSPEC   --- Number of pixels/spectrum, num of spectra
* REAL*8 ARC(2)         --- Wavelength scale of spectra (Velocity scale)
* REAL WAVE(NIMAGE)     --- Wavelengths of images
* INTEGER NIMAGE        --- Number of images
* REAL XCEN, YCEN       --- Centre of modified region in km/s
* REAL RADIUS           --- Radius in km/s
* REAL SHIFT            --- Shift to be applied (see below)
* REAL FACTOR           --- Factor to multiply errors by.
*
* Region to be changed is centred on the following velocity for each
* image:
*
* V = SHIFT - XCEN*COS(2*PI*(PHASE+OFFSET)) + YCEN*SIN(2*PI*(PHASE+OFFSET))
*
* and it includes all pixels within RADIUS km/s of this point.
* 
*
      REAL ERRORS(NPIX,NSPEC), PHASES(NSPEC), WAVE(NIMAGE)
      INTEGER NPIX, NSPEC, NIMAGE
      REAL*8 ARC(2)
      REAL XCEN, YCEN, RADIUS, SHIFT, FACTOR
      DATA VLIGHT/2.997925E5/
*
      TWOPI = 8.*ATAN(1.)
      DO I = 1, NIMAGE
        A = VLIGHT*(ARC(1)-LOG(WAVE(I)))
        B = VLIGHT*ARC(2)/REAL(NPIX)
        DO J = 1, NSPEC
          ANGLE = TWOPI*(PHASES(J)+OFFSET)
          VCEN = SHIFT - XCEN*COS(ANGLE) + YCEN*SIN(ANGLE)
          K1 = NINT((VCEN-RADIUS-A)/B)
          K2 = NINT((VCEN+RADIUS-A)/B)
          K1 = MAX(1, MIN(K1, NPIX))
          K2 = MAX(1, MIN(K2, NPIX))
          DO K = K1, K2
            ERRORS(K,J) = FACTOR*ERRORS(K,J)
          END DO
        END DO
      END DO
      RETURN
      END
