      REAL FUNCTION CHISQRD(DATA, FAKE, ERRORS, NPOINT, STATUS)
C
C     Computes Chi**2 between DATA and FAKE with uncertainties given
C     by ERRORS
C
      IMPLICIT NONE
      INCLUDE 'SAE_PAR'
      INTEGER NPOINT, I, NP, STATUS
      REAL DATA(NPOINT), FAKE(NPOINT), ERRORS(NPOINT)
      DOUBLE PRECISION SUM
C
      IF(STATUS.NE.SAI__OK) RETURN
      SUM = 0.D0
      NP  = 0
      DO I = 1, NPOINT
        IF(ERRORS(I).GT.0.) THEN
          SUM = SUM + ((DATA(I)-FAKE(I))/ERRORS(I))**2
          NP = NP + 1
        END IF
      END DO
      CHISQRD = REAL(SUM)/REAL(NP)
      RETURN
      END
