C+
      SUBROUTINE BOOT
*
* BOOT
*
* Written by T.R. Marsh, changes error bars
* in order to carry out bootstrap estimation of
* uncertainties on a fit to the data. In bootstrapping
* we pick N points out of the N data points, sampling
* with replacement. This is effectively equivalent to
* multiplying the weight assigned to each point during
* a fit by the number of times it was picked. This routine
* carries out this operation on the sigmas assigned to each
* point.
*
*
* FIGARO variables:
*
* DATA     -- Data file containing error array
*
* OUTPUT   -- Calculated data with altered error bars.
*
* ISEED    -- Initial seed integer for random number
*             generator. 
*
C+
      IMPLICIT NONE
*
* Functions
*
      INTEGER ICH_LEN
      REAL CHISQR
*
* Local variables
*
      INTEGER STATUS
      INTEGER DIMS1(10), DIMS2(10)
      CHARACTER*32 DATA, OUTPUT
      CHARACTER*32 CMPNAM, IMCOMP, SPCOMP, TYPE*16
      LOGICAL OOPEN, OMAP, FAULT, DOPEN
      INTEGER NDIMS1, NDIMS2, NELM, LFILE, IPOS, NSIDE
      INTEGER I, IFAIL, J, IEFIND, ICFIND, NMSTAT, NPIX
      INTEGER NSPEC, ISEED, ISLOT, IPIN1
      REAL SEED
      CHARACTER*80 ERROR
*
* Initialise logical flags
*
      FAULT = .TRUE.
      DOPEN  = .FALSE.
      OOPEN  = .FALSE.
      OMAP   = .FALSE.
*
* Open data file 
*
      CALL PAR_RDCHAR('DATA',' ',DATA)
      CALL DTA_ASFNAM('DATA',DATA(:ICH_LEN(DATA))//'.DST',
     &           'OLD',0,' ',STATUS)
      IF (STATUS.NE.0) THEN
         CALL FIG_DTAERR(STATUS,'Unable to open data file')
         GOTO 999
      END IF
      DOPEN = .TRUE.
*
*     Find and get size of errors array
*
      CALL DTA_SZVAR('DATA.Z.ERRORS',10,NDIMS2,DIMS2,STATUS)
      IF (STATUS.NE.0) THEN
         CALL FIG_DTAERR(STATUS,'Unable to find .ERRORS')
         GOTO 999
      END IF
      IF(NDIMS2.NE.2) THEN
        CALL PAR_WRUSER('Incorrect number of data dimensions', STATUS)
        GOTO 999
      END IF
      NPIX  = DIMS2(1)
      NSPEC = DIMS2(2)
*
* Get name of output file 
*
      CALL PAR_RDCHAR('OUTPUT', ' ', OUTPUT)
      CALL DTA_ASFNAM('OUTPUT',OUTPUT(:ICH_LEN(OUTPUT))//'.DST',
     &           'NEW',12,'Bootstrap',STATUS)
      IF (STATUS.NE.0) THEN
         CALL FIG_DTAERR(STATUS,'Unable to open data file')
         GOTO 999
      END IF
      OOPEN = .TRUE.
      CALL DTA_CYVAR('DATA', 'OUTPUT', STATUS)
      IF(STATUS.NE.0) THEN
        CALL PAR_WRUSER('Failed to create output file', STATUS)
        GOTO 999
      END IF
*
* Get seed integer for random number generator
*
      CALL PAR_RDVAL('ISEED',-1.E9,1.E9,12345.,' ', SEED)
      ISEED = - NINT(SEED)
*
* Map errors
*
      CALL DTA_MUVARF('OUTPUT.Z.ERRORS',NELM,IPIN1,STATUS)
      IF(STATUS.NE.0) THEN
        CALL PAR_WRUSER('Unable to map errors', STATUS)
        GOTO 999
      END IF
      OMAP = .TRUE.
*
* Modify uncertainties
*
      CALL BOOT_STRAP(%VAL(CNF_PVAL(IPIN1)), NPIX*NSPEC, ISEED)
*
* Set default value of ISEED for next call
*
      SEED = REAL(ISEED)
      CALL PAR_SDVAL('ISEED',SEED,STATUS)
      FAULT = .FALSE.
*
* Tidy up
*
999   CONTINUE
      IF(FAULT) CALL FIG_SETERR
      IF(OMAP) THEN
        CALL DTA_FRVAR('OUTPUT.Z.ERRORS', STATUS)
        IF(STATUS.NE.0) THEN
          CALL FIG_DTAERR(STATUS,'Error unmapping errors')
        END IF
      END IF
      IF (OOPEN) THEN
        CALL DTA_FCLOSE('OUTPUT',STATUS)
        IF (STATUS.NE.0) THEN
          CALL FIG_DTAERR(STATUS,'Error closing output file')
        END IF
      END IF
      IF (DOPEN) THEN
         CALL DTA_FCLOSE('DATA',STATUS)
         IF (STATUS.NE.0) THEN
           CALL FIG_DTAERR(STATUS,'Error closing input  file')
         END IF
      END IF
      RETURN
      END	

      SUBROUTINE BOOT_STRAP(ERROR, NPIX, ISEED)
*
* Modifies array ERROR(NPIX) to simulate sampling with
* replacement when ERROR(I) is used as the uncertainty
* estimate on a data point I. For example if a point is
* picked N times, ERROR(I) = ERROR(I)/SQRT(N). If N = 0
* multiply by a large number (1.E10)
*
* ISEED is a seed integer for the random number generator used to
* carry out the resampling. If -ve it implies a reset, otherwise
* it is ignored. A different and hopefully random one is returned
* on exit.
*
      PARAMETER (MAXPNT = 20000)
      INTEGER NPIX, ISEED, IPICK(MAXPNT)
      REAL ERROR(NPIX), RAN1
*
      IF(NPIX.GT.MAXPNT) THEN
        CALL PAR_WRUSER('Too many points for BOOT_STRAP', IFAIL)
        CALL PAR_WRUSER('Increase internal buffer', IFAIL)
        RETURN
      END IF
*
      DO I = 1, NPIX
        IPICK(I) = 0
      END DO
      DO I = 1, NPIX
10      CONTINUE
        J = INT(REAL(NPIX)*RAN1(ISEED))+1
        IF(J.LE.0 .OR. J.GT.NPIX) GOTO 10
        IPICK(J) = IPICK(J) + 1
      END DO
      BNUM = 1.E10
      DO I = 1, NPIX
        IF(IPICK(I).EQ.0) THEN
          ERROR(I) = BNUM*ERROR(I)
        ELSE
          ERROR(I) = ERROR(I)/SQRT(REAL(IPICK(I)))
        END IF
      END DO
      ISEED = NINT(1.E8*RAN1(ISEED))
      RETURN
      END
